.TH SETLGG_MACHINE 1 "21 November 2012"
.SH NAME
\fBsetlgg_machine\fP \- run the set language virtual machine
.SH SYNOPSIS
setlgg_machine [-d] [-D commands] [-c corefile] [-p pluginfile_1.so ... -p pluginfile_n.so] program_file memory_file
.SH DESCRIPTION
This command launches a setlgg virtual machine and run a program given in argument.
The syntax of the different files used by the virtual machine are explained later on this document.

The machine can perform simple actions like other assembly language with a native set of instructions containing some high level operations avoiding the need of an underlying operating system.
The instruction set can be enhanced by addition of plugins written in C/C++.
.SH OPTIONS
.TP
.B -d
This option switches the virtual machine in debug mode.
This mode allows the user to control the execution of the program, and investigate about program bugs.
Enter help in the debugger command line for more details about the debugger commands.
.TP
.B -D commands
This option switches the virtual machine in debug mode, like -d option.
The commands provided in input are run at startup.
.TP
.B -c corefile
This option set the file header of the eventual core file that could be generated when an error is not catched.
The real core file name is made by adding the PID of the setlgg_machine processus to the corefile option parameter.
This option can be set once.
.TP
.B -p pluginfile.so
This option add a plugin file to be loaded at the machine startup.
This option can be repeated.
.TP
.B -h
This option displays the basic help on the setlgg_machine processus options.
.TP
.B -v
This option displays the version and licence of the setlgg_machine command.
.SH EVALUATION OVERVIEW
The execution of the command with the right arguments is composed of several phases:
.SS "Plugins load"
At first, the shared libraries are dynamically loaded into the machine process, and the contained plugins are registered/configured in the machine itself.
.SS "Program compilation and link"
Then, the program file is read and its content is compiled and linked.
.SS "Memory load"
The memory file is read and its content is loaded into the virtual machine memory.
If the memory file does not exist, the memory remains void.
.SS "Boot"
The processor is switched on, with all registers set to zero.
.SS "Program execution"
The processor executes the program, instruction by instruction. After the last instruction, an invisible instruction is added to shutdown the machine.
.SS "Shutdown"
On a program error or an explicit instruction, the program execution ends.
.SS "Memory save & core dumping"
When the program exits on an error and a core file name has been provided in input, the virtual machine dumps its own state into a file and adds the error message that produced the core dump.
Otherwise, the current state of the memory is written in the memory file provided in input. The file is created if it did not exist.
.SH VIRTUAL MACHINE ARCHITECTURE
The virtual machine is made of five elements:
.IP "processor"
The processor is the element that reads the different instructions written in the program and performs the associated actions.
.IP "memory"
The memory contains all data handled by the running program.
No instructions can be put in this memory.
.IP "program"
The program is a specific memory that contains the running program.
The program and the data have different address spaces.
.IP "streams"
The streams deal with communication to the outside environment of the virtual machine.
They can be represented by a pipe with one side into the virtual machine and the other one outside, allowing data written on one side to appear on the other one.
The streams can use several system medias to convey the data, like files and sockets.
Internally, streams may use a buffer to store data read from the media itself. It could miss some data change on modified-during-read medias while reading data from the stream.
.IP "plugins"
The plugins provide extensions of the memory and the processor.
They can define new types storable in the memory, and new instructions added to the processor.
.SS "The processor"
The core of the processor is made of a state including several registers:
.IP "Instruction pointer"
This register always contains the address of the next instruction that will be executed by the processor.
This register is automatically incremented when an instruction is executed.
If an instruction changes this value with a program address, the resulting operation is a jump to this address at the end of the current instruction.
This register is filled with the <0> address at boot time.
.IP "Current memory address"
This register contains an address to the data memory.
The aim of this register is to allow the same part of the code running on values stored in memory where their address is determined at execution time.
Thi situation occurs in particular inside functions, where the location of the parameters can not be known in advance.
This register is filled with the &0 address at boot time.
.IP "Checkpoints"
This register contains named flags acting like booleans with history at a frame level.
These flags can be set several times. It will be necessary to remove them the same times to see the flag disappear.
The existence of a flag can be tested in conditions, for conditional jumping.
.P
At some points in the code, the current state of the processor needs to be stored temporarily, in order to run a part of the code in a specific context.
When this specific context reaches the end of its existence, the previous state needs to be restored.
To do this, to processor also contains a stack of states to store all states, allowing the processor to return to a previous state.
For this reason, this stack is sometimes called the processor return stack.
.P
For some reasons, the processor sometimes needs to interrupt the execution of the code without any specific jump instruction.
It occurs when the machine receives a signal from the system - it is a kind of hardware interruption - or when an instruction raises an exception - it is a kind of software interruption -.
Without any setting, the virtual machine stops with an error when a software interruption occurs, or do the system default action when an hardware interruption occurs.
But it is possible to let the processor know where it should jump in the case a specific interruption is raised.
In such case, the interruption is stacked, and the jump is performed after the current instruction execution.
The current state is kept before the jump, and can be restored when the code associated to the interruption is executed.
.P
The possible interruptions are:
.TP
HUP
Raised when the virtual machine receives a SIGHUP.
.TP
KBINT
Raised when the virtual machine receives a SIGINT.
.TP
QUIT
Raised when the virtual machine receives a SIGQUIT.
.TP
ILL
Raised when the virtual machine receives a SIGILL or when an instruction is malformed.
.TP
ABRT
Raised when the virtual machine receives a SIGABRT or when an instruction process finds an error.
.TP
FPE
Raised when the virtual machine receives a SIGFPE or when a division or a remainder by 0 occurs.
.TP
SEGV
Raised when the virtual machine receives a SIGSEGV or when a memory related operation fails.
.TP
PIPE
Raised when the virtual machine receives a SIGPIPE or when a stream related operation fails.
.TP
ALRM
Raised when the virtual machine receives a SIGALRM.
.TP
TERM
Raised when the virtual machine receives a SIGTERM.
.TP
USR1
Raised when the virtual machine receives a SIGUSR1.
.TP
USR2
Raised when the virtual machine receives a SIGUSR2.
.TP
CHLD
Raised when the virtual machine receives a SIGCHLD or when a clone shutdowns.
.TP
CONT
Raised when the virtual machine receives a SIGCONT.
.TP
TSTP
Raised when the virtual machine receives a SIGTSTP.
.TP
TTIN
Raised when the virtual machine receives a SIGTTIN.
.TP
TTOU
Raised when the virtual machine receives a SIGTTOU.
.TP
BUS
Raised when the virtual machine receives a SIGBUS.
.TP
PROF
Raised when the virtual machine receives a SIGPROF.
.TP
URG
Raised when the virtual machine receives a SIGURG.
.TP
IO
Raised when the virtual machine receives a SIGIO.
.SS "The memory"
The memory can be represented by an array of values having a type.
Each value can be read and written using a numeric reference called address.
At boot time, the memory is filled with the memory file provided in input, and new addresses need to be allocated by an instruction before storing any value to it, and freed when those addresses become useless.
One of the most difficult part in the assembly programming is to correctly handle memory allocations, avoiding the memory to contains allocated addresses that have no more meaning for the application.
.P
The syntax of the memory file is explained in the MEMORY FILE SYNTAX chapter below.
.P
The types allowed in memory are:
.IP "INT"
This type represents a long int on the system.
.IP "STR"
This type represents a text string without size limitation except the host memory.
.IP "BLN"
This type represents a boolean.
The two possibles values are TRUE and FALSE.
.IP "PTR"
This type represents a memory address.
It can be used to store a pointer to another value inside a specific address.
.IP "IOR"
This type represents an input/output reference.
It can be used to store a stream name.
.IP "USR(usertypename) where usertypename is an identifier"
This class of types lets the user to store in memory types defined in plugins.
The instruction set of the processor need to be extended to handle those types, as no built-in instructions will accept the values of those types.
.P
Aliases can be associated to addresses, and can behave like global variables.
Each alias is unique at a given time and linked to one address, and can be used instead of the numerical value.
The alias are removed when the corresponding addresses are freed.
.SS "The program"
The program is made of a list of instructions executed from the first one to the last one, if no instruction makes a jump to another one.
Among the instructions, the \fB:label\fP one is quite special, as it has no address by itself, but marks the following instruction to be the destination of a jump.
.P
The program contained in the file provided on the command line is compiled before boot time, and generates an internal representation of the program to be able to run it.
After this conversion, a link between the addresses marked by the label instructions and the jump instructions is done to speed up the jumps during the execution.
.P
Please refer to the PROGRAM SYNTAX section below to see how to write a program.
.SS "The streams"
The streams are a dedicated way to exchange data with the outside world.
The possible medias used to convey the data can be the files, the network sockets with connected protocols and datagram protocols, and the anonymous pipes.
A unique name is associated to each stream, in order to apply the different operations on it.
.P
The possible operations that can be applied to streams are:
.IP "open"
The open operation creates the stream with all settings to be able to perform the other operations on the stream, and opens the underlying media.
.IP "close"
The close operation closes the underlying media and removes the stream from the known streams.
All instructions that refer to this stream will raise an ABRT interruption afterwards.
.IP "read"
The read operation gets some data from the outside world and transforms them according to a specific format.
.IP "write"
The write operation takes a value and transforms it according a specific format and sends the data to the outside world.
.IP "seek"
The seek operation moves the read/write cursor inside the stream, to allow read and write operations at differents places of the stream.
.IP "wait"
Two different wait operations can be done:
.P
The first one is specific to the streams on a server side connected socket.
This operation will wait for a client connection and open another stream to handle the communication with the client.
.P
The second one can be done on any stream type, and will wait for a read or a write event on several streams. The main goal of this operation is to mux datas from several sources.
.SS "The plugins"
The plugins are shared libraries loaded before the boot of the virtual machine, and extend the capabilities of the memory, the processor and the stream handling.
The shared library shall export some specific symbols corresponding to its own configuration towards the virtual machine and the functionalities it exposes to the virtual machine.
.P
Please refer to the HOW TO WRITE A PLUGIN for more details on the plugin structure.
.P
The plugins can be interdependant, and their dedependancies are checked when all of them are loaded.
After the boot, it is not possible to add any plugin to the machine, to ensure that the meaning of each processor instruction will not change during the execution of the program.
.SH PROGRAM SYNTAX
The program is made of a succession of instructions and commentars.
Each instruction is terminated with a carriage return, so it is impossible to put more than one instruction on the same line.
If the character \fB#\fP is present, the character and the rest of the line is ignored by the program loader.
.P
By convention here, the syntax of the instructions will be \fIhighlighted like this\fP with the arguments placed in square brackets like <this>.
.P
.SS "Memory addresses"
.HP
A memory address can be built from a positive integer value.
It is formed by the character \fB&\fP followed by an integer constant, or the \fB&\fP followed by a read from the memory.
In this second case, the value stored in memory shall be a PTR typed value, or the SEGV interruption will be raised.
.HP
For example: \fI&31\fP is a constant address, \fI&@&31\fP is an address read from the memory at the address &31.
.HP
One register of the processor contains a memory address, called the current memory address.
In order to obtain this current address, the \fI:current\fP keyword can be used in place of an address.
.HP
For example: \fI@:current\fP is a read from the memory at the current address.
.HP
An address can be deduced by the processor from an alias.
An alias is a simple identifier replacing a constant address.
If the alias has not been linked to an address, a SEGV interruption will be raised.
.HP
For example: \fIan_alias\fP is the address linked to the alias, \fI@an_alias\fP is a read from the memory at the address linked to the alias.
.HP
An address can be formed from another address adding or substracting an integer.
The syntax is \fI(<address> + <offset value>)\fP or \fI(<address> - <offset value>)\fP.
Please note that the parenthesis are part of the address syntax.
.HP
For example: \fI@(:current + 1)\fP is a read from the memory at the address following the current memory address, \fI(an_alias - 3)\fP is the address placed 3 positions before the address linked to the alias an_alias.
In the addresses \fI&@(:current + 1)\fP and \fI(&@:current + 1)\fP, you should take care of the order of the operations, as the offset is applied on the \fI:current\fP address in the first form and on the \fI&@:current\fP address in the second form.
.SS "Formats"
A format is a special syntax used to convert integers or strings into integers or strings.
.IP "String to string"
This format is \fI~s\fP.
It only keeps the string as it.
.IP "ASCII character conversion"
This format is \fI~c\fP.
An integer between 0 and 255 is converted to a single character string with the corresponding ASCII character, and a single character string is converted to an integer representing the ASCII code of the character.
.IP "Integer to string or string to integer"
This format is composed of options in \fI# +-0\fP followed by a positive integer and ended by \fIidoxX\fP.
Please refer to the printf function to know the meaning of this format.
.SS "Input/Output references"
Input/Output references are specific values placed on stream instructions to specify on which stream the action will be performed.
These references can be built from a simple identifier preceded by a \fI$\fP character.
A reference can also be deduced from an INT or a STR, with the syntax \fI$(<INT or STR or @address>)\fP.
If an INT value is used, the name of the stream is generated with the ~08d format.
If a STR is used, any string is valid, except the empty string.
An ABRT interruption will be raised if an empty string is used.
A reference can also be read from the memory, with the syntax \fI$@<address>\fP.
.P
Some keywords refer to specific streams opened before boot time:
.IP "Standard input"
The keyword \fI:stdin\fP is the standard input reference.
This stream is opened in read only mode, and is not seekable.
The standard input is often used to get the user inputs.
.IP "Standard output"
The keyword \fI:stdout\fP is the standard output reference.
This stream is opened in write only mode, and is not seekable.
The standard output is often used to send messages and responses to the user.
.IP "Standard error"
The keyword \fI:stderr\fP is the standard error reference.
This stream is opened in write only mode, and is not seekable.
The standard error is often used to send error messages to the user.
.SS "Values"
.HP
A value can be a constant of type INT, STR, BLN, PTR or IOR.
Integers are formed by a succession of characters 0 to 9, with a - character before the first digit when the number is negative.
Strings are formed by a succession of characters placed between double quotes ".
Some characters need to be escaped: \\n represents a carriage return, \\r a line feed, \\t a tabulation, \\" a double quote inside the string and \\\\ a backslash. A \\0 followed by two hexadecimal characters is converted to the corresponding ASCII character.
Booleans can be represented only by two values: TRUE and FALSE.
Pointers follow the address syntax.
Input/Output references follow the input/output reference syntax.
.HP
For example: \fI-31415\fP is a valid integer, \fI"bla\\nbla"\fP is a valid string, \fITRUE\fP is a valid boolean, \fI&0\fP is a valid pointer and \fI$stream\fP, \fI$("stream")\fP are valid input/output references.
.HP
A read from the memory is specified by preceding a memory address by the \fB@\fP character.
The machine will perform a read from the memory at the given address, and uses the stored value in place in the expression.
If the address is not defined - not allocated beforehand - or not initialised - when no value is affected to the address - or when the value is not of the right type, a SEGV interruption will occur.
.HP
For example: \fI@&0\fP is a read from the constant address &0, \fI@an_alias\fP is a read from the address linked to the alias an_alias, \fI@:current\fP is a read from the current memory address.
.HP
A value can be the result of the \fI:rand\fP built-in operator.
This operator returns a pseudo-random value of type INT between 0 and RAND_MAX on your system. The pseudo-random seed is set with the UNIX time when the program is loaded into the machine.
.SS "Expressions"
An expression can be a single value or an operator with its arguments.
.HP
\fBInteger operators\fP:
.IP "- (negation)"
Syntax: \fI- <integer value>\fP -> INT.
Returns the opposite integer of the argument.
.IP "+ (addition)"
Syntax: \fI<left integer value> + <right integer value>\fP -> INT.
Returns the sum of the two integers.
.IP "- (substraction)"
Syntax: \fI<left integer value> - <right integer value>\fP -> INT.
Returns the difference of the two integers.
.IP "* (multiplication)"
Syntax: \fI<left integer value> * <right integer value>\fP -> INT.
Returns the product of the two integers.
.IP "/ (division - quotient)"
Syntax: \fI<left integer value> / <right integer value>\fP -> INT.
Returns the quotient of the euclidian division of the two integers.
.IP "% (division - remainder)"
Syntax: \fI<left integer value> % <right integer value>\fP -> INT.
Returns the remainder of the euclidian division of the two integers.
.IP ":min (minimum)"
Syntax: \fI<left integer value> :min <right integer value>\fP -> INT.
Returns the smaller integer of the two integers.
.IP ":max (maximum)"
Syntax: \fI<left integer value> :max <right integer value>\fP -> INT.
Returns the bigger integer of the two integers.
.IP "= (equal)"
Syntax: \fI<left integer value> = <right integer value>\fP -> BLN.
Returns \fITRUE\fP if the two integers are equal, \fIFALSE\fP otherwise.
.IP "<> (different)"
Syntax: \fI<left integer value> <> <right integer value>\fP -> BLN.
Returns \fITRUE\fP if the two integers are different, \fIFALSE\fP otherwise.
.IP "< (inferior)"
Syntax: \fI<left integer value> < <right integer value>\fP -> BLN.
Returns \fITRUE\fP if the left integer is smaller than the right one, \fIFALSE\fP otherwise.
.IP "<= (inferior or equal)"
Syntax: \fI<left integer value> <= <right integer value>\fP -> BLN.
Returns \fITRUE\fP if the left integer is smaller than the right one or equal to it, \fIFALSE\fP otherwise.
.IP "> (superior)"
Syntax: \fI<left integer value> > <right integer value>\fP -> BLN.
Returns \fITRUE\fP if the left integer is bigger than the right one, \fIFALSE\fP otherwise.
.IP ">= (superior or equal)"
Syntax: \fI<left integer value> >= <right integer value>\fP -> BLN.
Returns \fITRUE\fP if the left integer is bigger than the right one or equal to it, \fIFALSE\fP otherwise.
.HP
\fBString operators\fP:
.IP ":size (size)"
Syntax: \fI:size <string value>\fP -> INT.
Returns the number of characters present in the string.
.IP "+ (concatenation)"
Syntax: \fI<left string value> + <right string value>\fP -> STR.
Returns a string that contains the left one then the right one.
.IP "- (character)"
Syntax: \fI<left string value> - <right integer value>\fP -> INT.
Returns the ASCII code of the character in the left string placed at the right integer position.
The first character position is 0.
If the right argument is negative or superior or equal to the left string size, an ABRT interruption is raised.
.IP ":substring (substring extraction)"
Syntax: \fI:substring <string> <position> <size>\fP -> STR or \fI:substring <string> <position> <size> END\fP -> STR.
Returns a string extracted from the one given in argument.
The position indicates the first character of the substring, and the size indicates how many characters should be extracted.
If the keyword END is specified, the position 0 is the character after the last one in the given string, instead of the first one.
A negative size indicates that the characters before the position should be extracted instead.
If the position and size does not match a substring included in the string, the returned substring will contain less than the requested size.
.IP "/ (regular expression - first match)"
Syntax: \fI<left string value> / <right string value>\fP -> STR.
Returns the first match in the left string of the POSIX regular expression pattern contained in the right string.
.IP "% (regular expression - remainder)"
Syntax: \fI<left string value> % <right string value>\fP -> STR.
Returns the string after the first match in the left string of the POSIX regular expression pattern contained in the right string.
.IP ":min (minimum)"
Syntax: \fI<left string value> :min <right string value>\fP -> STR.
Returns the first string in the lexical order.
.IP ":max (maximum)"
Syntax: \fI<left string value> :max <right string value>\fP -> STR.
Returns the second string in the lexical order.
.IP "= (equal)"
Syntax: \fI<left string value> = <right string value>\fP -> BLN.
Returns \fITRUE\fP if the two strings are equal, \fIFALSE\fP otherwise.
.IP "<> (different)"
Syntax: \fI<left string value> <> <right string value>\fP -> BLN.
Returns \fITRUE\fP if the two strings are different, \fIFALSE\fP otherwise.
.IP "< (inferior)"
Syntax: \fI<left string value> < <right string value>\fP -> BLN.
Returns \fITRUE\fP if the left string is before the right one in the lexical order, \fIFALSE\fP otherwise.
.IP "<= (inferior or equal)"
Syntax: \fI<left string value> <= <right string value>\fP -> BLN.
Returns \fITRUE\fP if the left string is before the right one in the lexical order or equal to it, \fIFALSE\fP otherwise.
.IP "> (superior)"
Syntax: \fI<left string value> > <right string value>\fP -> BLN.
Returns \fITRUE\fP if the left string is after the right one in the lexical order, \fIFALSE\fP otherwise.
.IP ">= (superior or equal)"
Syntax: \fI<left string value> >= <right string value>\fP -> BLN.
Returns \fITRUE\fP if the left string is after the right one in the lexical order or equal to it, \fIFALSE\fP otherwise.
.HP
\fBBoolean operators\fP:
.IP ":not (logical negation)"
Syntax: \fI:not <boolean value>\fP -> BLN Returns the number of characters present in the string.
.IP ":and (logical and)"
Syntax: \fI<left boolean value> :and <right boolean value>\fP -> BLN.
Returns \fITRUE\fP when the left boolean is \fITRUE\fP and the right one is \fITRUE\fP, \fIFALSE\fP otherwise.
.IP ":or (logical inclusive or)"
Syntax: \fI<left boolean value> :or <right boolean value>\fP -> BLN.
Returns \fITRUE\fP when the left boolean is \fITRUE\fP or the right one is \fITRUE\fP, \fIFALSE\fP otherwise.
If both are \fITRUE\fP, the operator returns also \fITRUE\fP.
.IP ":xor (logical exclusive or)"
Syntax: \fI<left boolean value> :xor <right boolean value>\fP -> BLN.
Returns \fITRUE\fP when the left boolean is \fITRUE\fP or the right one is \fITRUE\fP, \fIFALSE\fP otherwise.
If both are \fITRUE\fP, the operator returns \fIFALSE\fP.
.IP "= (equal)"
Syntax: \fI<left boolean value> = <right boolean value>\fP -> BLN.
Returns \fITRUE\fP if the two booleans are equal, \fIFALSE\fP otherwise.
.IP "<> (different)"
Syntax: \fI<left boolean value> <> <right boolean value>\fP -> BLN.
Returns \fITRUE\fP if the two booleans are different, \fIFALSE\fP otherwise.
.HP
\fBPointer operators\fP:
.IP "- (offset)"
Syntax: \fI<left pointer value> - <right pointer value>\fP -> INT.
Returns the difference of two pointers.
.IP "= (equal)"
Syntax: \fI<left pointer value> = <right pointer value>\fP -> BLN.
Returns \fITRUE\fP if the two pointers reference the same memory address, \fIFALSE\fP otherwise.
Please note that the operator takes in argument two pointers written in memory and not addresses.
.IP "<> (different)"
Syntax: \fI<left pointer value> <> <right pointer value>\fP -> BLN.
Returns \fITRUE\fP if the two pointers reference two different memory addresses, \fIFALSE\fP otherwise.
Please note that the operator takes in argument two pointers written in memory and not addresses.
.HP
\fBInput/Output references\fP:
.IP "= (equal)"
Syntax: \fI<left input/output reference value> = <right input/output reference value>\fP -> BLN.
Returns \fITRUE\fP if the two input/output references are identical, \fIFALSE\fP otherwise.
.IP "<> (different)"
Syntax: \fI<left input/output reference value> <> <right input/output reference value>\fP -> BLN.
Returns \fITRUE\fP if the two input/output references are different, \fIFALSE\fP otherwise.
.SS "Conditions"
The conditions are placed after some instructions.
Most of these instructions are jump instructions.
.HP
\fBGlobal syntax\fP
.IP "<instruction> :when <condition>"
The instruction attached to the condition is executed only if the condition following the \fI:when\fP keyword is true.
.IP "<instruction> :unless <condition>"
The instruction attached to the condition is executed only if the condition following the \fI:unless\fP keyword is false.
.HP
.B Comparison conditions
The comparison operators \fI=\fP, \fI<>\fP, \fI<\fP, \fI<=\fP, \fI>\fP, \fI>=\fP are accepted as possible conditions after the \fI:when\fP and \fI:unless\fP keywords.
.HP
.B Specific conditions
.IP ":defined (allocated address)"
Syntax: \fI<memory address> :defined\fP.
This condition is true if the corresponding address has been allocated by the \fI:new\fP instruction.
.IP ":initialised (allocated address with a value)"
Syntax: \fI<memory address> :initialised\fP.
This condition is true if the corresponding address has been allocated by the \fI:new\fP instruction, and the address has been affected with a value using the \fI->\fP instruction.
.IP ":readable (readable stream)"
Syntax: \fI<input/output reference> :readable\fP.
This condition is true if the corresponding stream can support the \fI:read\fP instruction.
.IP ":writable (writable stream)"
Syntax: \fI<input/output reference> :writable\fP.
This condition is true if the corresponding stream can support the \fI:write\fP instruction.
.IP ":seekable (seekable stream)"
Syntax: \fI<input/output reference> :seekable\fP.
This condition is true if the corresponding stream can support the \fI:seek\fP instruction.
.IP ":true (boolean condition)"
Syntax: \fI<boolean value> :true\fP.
This condition is true if the boolean is equal to \fITRUE\fP.
.IP ":empty (empty string condition)"
Syntax: \fI<string value> :empty\fP.
This condition is true if the string contains no characters.
.IP ":reached (checkpoint condition)"
Syntax: \fI<string value> :reached\fp.
This condition is true if the named checkpoint is present on the current CPU state.
.IP ":clone (clone instruction)"
Syntax: \fI<clone instruction>\fP.
This condition is true if the \fI:clone\fP instruction returns \fITRUE\fP.
Please refer to the \fI:clone\fP instruction documentation below.
.SS "-> (Write to memory)"
This instruction writes the result of an expression or an instruction into the memory at a specific address.
The syntax is \fI<expression or instruction> -> <memory address>\fP.
A SEGV interruption will be raised if the memory address has not been defined or if the type of the value mismatches the type specified when the memory address has been allocated.
All instructions returning a value should be a candidate to be placed on the left side of the instruction. Please refer to the documentation of \fI:child\fP, \fI:clone\fP, \fI:convert\fP, \fI:coredump\fP, \fI:date\fP, \fI:new\fP, \fI:read\fP, \fI:seek\fP and user instructions when they return a value.
.SS ":call"
This instruction performs a call to the function defined at a specific label with a memory address to locate the function parameters.
The syntax is \fI:call <label to function> <parameters address>\fP.
For the label definition, please refer to the \fI:label\fP instruction.
This instruction pushes the current processor state on the return stack, changes the current address to the parameters address, and jumps to the label of the function.
.P
If the label is a string or a read into the memory, the string value is taken as label. The resolution of the label to the program address is done when the instruction is executed and not when the program is loaded.
This dynamic linkage is very slow compared to the static linkage (when the label is a simple identifier) and should be used sparingly.
.SS ":checkpoint"
This instructions adds or remove a checkpoint into the current CPU state.
The syntax is \fI:checkpoint <checkpoint name>"\fP or \fI:checkpoint <checkpoint name> <action boolean>"\fP.
When the second parameter is omitted, TRUE is taken by default.
The instruction adds a checkpoint if the boolean is TRUE and removes a checkpoint if the boolean is FALSE.
The CPU will count how many adds of the checkpoint has been done, and will remove the checkpoint after the same number of deletions.
.SS ":child"
This instruction waits for a machine clone to shutdown and returns the shutdown code. If the child process has been killed by a signal, the return value is the nul integer.
The syntax is \fI:child\fP.
The use of this instruction is recommanded in the code called after a CHLD interruption.
Please refer to the \fI:clone\fP and \fI:interruption\fP instruction documentation.
.SS ":clone"
This instruction clones the virtual machine, and returns a boolean to determine in which machine the execution continues.
The boolean is \fITRUE\fP in the cloned machine and \fIFALSE\fP in the original machine.
The syntax is \fI:clone\fP or \fI:clone <input/output reference>\fP.
In the second syntax, a stream is opened between the original machine and its clone, to let them communicate through this stream.
.SS ":clear"
This instruction clears the memory at a given address.
The syntax is \fI:clear <memory address>\fP.
If the address is invalid, a SEGV interruption is raised.
.SS ":close"
.IP "Stream closure"
This instruction closes a stream.
All instructions related to the streams will not work anymore on the closed stream.
The input/output reference linked to the stream can be reused for another stream.
The syntax is \fI:close <input/output reference>\fP.
.IP "One-way stream closure"
On pipe tubes based streams, \fI:close\fP accepts the syntaxes \fI:close > <input/output reference>\fP or \fI:close < <input/output reference>\fP.
The first will close only the write way and the second one the read way.
The stream is still open and usable for the non yet closed ways.
The input/output reference is still linked to the stream and need to be freed with the previous \fI:close\fP syntax.
.SS ":convert"
This instruction converts a string representing an integer to the corresponding integer, or an integer to the corresponding string.
The syntax is \fI:convert <format> <value>\fP.
If the format is not correct, a ILL interruption will be raised.
.SS ":coredump"
This instruction dumps the state of the virtual machine into a stream or a string.
The syntax is \fI:coredump <input/output reference>\fP to dump into a stream, and the instruction returns a string value that can be written into memory.
If the input/output reference is not provided, the instruction will not write the dump into a stream, and will only return the string.
.SS ":date"
This instruction handles two operations on dates:
.IP "Current date"
The first one returns the current date as an integer.
The syntax is \fI:date <UTC or LOCAL>\fP.
.IP "Date formatting"
The second one formats a given date to a string.
The syntax is \fI:date <integer date in unix epoch> <UTC or LOCAL> <string date format>\fP.
The current date is used if the integer date is omitted.
In the string format, the \fB%Y\fP is replaced by the four digits year, \fB%M\fP is replaced by the two digits month, \fB%D\fP is replaced by the day of the month, \fB%h\fP is replaced by the hours, \fB%m\fP is replaced by the minutes, \fB%s\fP is replaced by the seconds, \fB%e\fP is replaced by UNIX epoch, \fB%w\fP is replaced by the numeric week day - 0 or 7 is Sunday - \fB%z\fP is replaced by the daylight saving time, \fB%J\fP is replaced by the julian date and \fB%%\fP is replaced by the \fB%\fP character.
.SS ":debug"
This instruction sends a directive to the debugger, in debug mode. This instruction is ignored when the debugger is not active.
The syntax of the instruction is \fI:debug <string directive>\fP.
The directives to the debugger are:
.IP "Frame begin"
The syntax is "frame begin" or "frame begin file <filename> <line>".
This directive tells the debugger that a function call has been performed in the source language.
.IP "Frame end"
The syntax is "frame end" or "frame end file <filename> <line>".
This directive tells the debugger that a return from a function call has been performed in the source language.
.IP "Instruction"
The syntax is "instruction <instruction string>" or "instruction <intruction string> file <filename> <line>".
This directive tells the debugger that an instruction has been started in the source language.
.IP "Symbol"
The syntax is "symbol <symbol string>" or "symbol <symbol string> file <filename> <line>".
This directive tells the debugger on which program address is defined a symbol from the source language.
.IP "Variable"
The syntax is "variable <variablename string> <memory address>" or "variable <variablename string> <memory address> file <filename> <line>".
This directive tells the debugger that a variable has been defined in the current frame, and links it to its memory address.
.P
The strings in the debugger directives are surrounded by simple quotes, or names without quotes and spaces. The backslash can escape the chosen delimiter (simple quote or space) and the backslash.
If the file part is not set, the line in the assembly program is taken by default.
Each debug directive can be followed by a condition, except the \fI:clone\fP one. The directive is taken in account only if the condition is true.
.P 
Failing directives are reported before the boot of the machine in debug mode.
.SS ":decrease"
This instruction decreases an integer or a pointer stored at a specified address.
The syntax is \fI:decrease <constant positive integer> <address>\fP where the constant positive integer is 1 when omitted.
If the value stored at the specified address is not an integer nor a pointer, a SEGV interruption will be raised.
.SS ":delete"
This instruction frees memory blocs.
The syntax is \fI:delete <non empty list of blocs separated by commas>\fP where each block is formed of \fI<address> * <positive integer as size>\fP, with a default size of 1 if omitted.
If an address is invalid, a SEGV interruption will be raised, and no address is freed.
On success, all addresses are undefined after the \fI:delete\fP instruction.
.P
For example: \fI:delete &0 , an_alias*3 , &@t * @i\fP deletes the address &0, 3 addresses from the an_alias one and @i addresses from the address stored at the t address.
.SS ":exec"
This instruction launches an external command.
The syntax is \fI:exec <input/output reference> <string with full path command>, <list of string arguments, each argument preceded by a comma>\fP or \fI:exec <input/output reference> <input/output reference> <string with full path command>, <list of string arguments, each argument preceded by a comma>\fP.
The stream is opened by the \fI:exec\fP instruction, and need to be closed by the \fI:close\fP instruction.
This stream is connected to the standard input and the standard output of the external command, and allows the communication between the virtual machine and the command through \fI:read\fP and \fI:write\fP instructions.
All other file handlers are closed by the instruction before launching the programm, stderr excepted if it is still linked to the terminal.
.P
With the second form, the second stream is linked to the standard error of the external command, and is only readable. This stream has to be closed when it becomes unuseful.
.SS ":goto"
This instruction is the basic jump.
The syntax is \fI:goto <label> <condition>\fP where the condition is always true when omitted.
If the condition is true, the instruction pointer of the processor is filled by the program address linked to the corresponding \fI:label <label>\fP instruction.
In this case, the execution of the program continues after the label.
.P
If the label is a string or a read into the memory, the string value is taken as label. The resolution of the label to the program address is done when the instruction is executed and not when the program is loaded.
This dynamic linkage is very slow compared to the static linkage (when the label is a simple identifier) and should be used sparingly.
.SS ":increase"
This instruction increases an integer or a pointer stored at a specified address.
The syntax is \fI:increase <constant positive integer> <address>\fP where the constant positive integer is 1 when omitted.
If the value stored at the specified address is not an integer nor a pointer, a SEGV interruption will be raised.
.SS ":interruption"
This instruction administrates the interruption handler list of the processor.
The syntax is \fI:interruption <interruption name> <label>\fP to specify the handler for the given interruption, or \fI:interruption <interruption name>\fP to restore the previous behaviour of the interruption.
The interruption name is one word listed in the Processor sub section above.
When an handler is defined for a raised interruption, the processor does a call like the \fI:call\fP instruction, without changing the current memory address.
It means that a \fI:return\fP instruction will continue the execution where the processor was before the interruption.
.SS ":label"
This instruction is not executed in itself by the processor.
It only makes a link between a name, the label, and the program address of the first non label instruction after the label.
The syntax is \fI:label <label>\fP where label is a simple identifier.
The label needs to be unique per program.
.SS ":new"
This instruction allocates a bloc of memory.
The syntax is \fI:new <non empty list of memory places separated by commas>\fP, where each place is formed of \fI<type> * <positive integer as size> / <alias>\fP, with a default size of 1 if omitted.
It the alias is precised, the alias is linked to the first address of the place and needs to be unique during the execution.
On success, the allocated addresses are contiguous in the memory, and the \fI:new\fP instruction returns the address of the first allocated memory address.
On failure, a SEGV interruption will be raised and no memory address will be defined.
.P
For example : \fI:new PTR/pointer\fP will define one address of type PTR linked to the alias pointer, \fI:new INT*10 , BLN/blnerr , STR*5 -> pointer\fP will define an array of 10 integers, one boolean and 5 strings, links the boolean to the alias blnerr and stores the address of the first integer into the pointer address.
.SS ":open"
This instruction opens a stream.
On success, the stream is opened, and is ready for the other stream operations.
On failure, an ABRT interruption will be raised.
The syntax of the instruction is linked to the underlying media used to convey the data in the stream.
.IP "File stream"
The syntax is \fI:open <input/output reference> <stream mode> <string as file name>\fP where the stream mode is \fB<\fP for a read only stream, \fB>\fP for a write only stream, \fB> >\fP for a write only stream in append mode and \fB< >\fP for a read/write stream.
Please note the space between the two characters.
The file will not be created in read only mode, will be truncated or created in write only mode, will be created and the cursor placed at the end in write append mode and will be only created in read/write mode.
The string represents the file name, where the . directory is the working directory of the virtual machine.
.IP "Stream socket"
The syntax is \fI:open <input/output reference> TCP <stream mode> <string as IPv4/IPv6/domain name> <integer or string as port number/service name>\fP where the stream mode is \fB<\fP for a socket on server side, and \fB>\fP for a socket on client side.
Please refer to the \fI:wait\fP instruction for the use of TCP streams on server side.
.IP "Datagram socket"
The syntax is \fI:open <input/output reference> UDP <string as local IPv4/IPv6/domain name> <integer or string as local port number/service name> < > <string as distant IPv4/IPv6/domain name> <integer or string as distant port number/service name>\fP where the characters \fB< >\fP separates the local connection parameters and the distant connection parameters.
.SS ":read"
This instruction reads some data on a stream and converts it according a format.
The syntax is \fI:read <input/output reference> <format> <read mode>\fP where the read mode can be \fBALL\fP meaning a read returning at the end of the stream, \fBLINE\fP meaning a read returning the next line, without the trailing \\n character, or \fBAVAILABLE\fP meaning a read that will return all data received until the read instruction, and returning an empty string if none was available. The read mode can also be a positive integer or a read into the memory for an integer. In such case, \fI:read\fP will return up to the number of characters from the stream. If the number is negative, an ILL interruption is raised.
The read instruction will raise a PIPE interruption on failure, and returns a null value when the end of stream is reached for \fBLINE\fP and \fBAVAILABLE\fP modes. As the \fBALL\fP mode returns the whole stream, this mode will return an empty string when an end of stream is reached immediately.
.SS ":receive"
This instruction receives a memory block from a stream.
The syntax of the instruction is \fI:receive <input/output reference> <string as block name> <memory block>\fP. The memory block can be omitted. In such case, the instructions returns the address where the memory block has been written in memory.
If the memory block is specified, the incomming block replaces the memory at the given location, if size and types matches.
The instruction will also control the name of the memory block, and shifts block internal pointers: if a pointer in the incomming block was pointing outside the block, it remains as it. Otherwise, the new pointer will be modified to continue to refer to an address inside the written block.
The instruction can raise a PIPE interruption if the stream is not readable, not writable when it is based on a socket or pipe tubes. A SEGV interruption is raised if a type/size mismatch is detected. An ABRT interruption is raised in other cases.
If the incomming message is ill-formed, the stream reads are rollen back.
When the stream is based on a socket or pipe tubes, the sender is notified if an error occured. Please refer to the \fI:send\fP instruction.
.SS ":return"
This instruction returns from a function to its caller.
The syntax is \fI:return <constant positive integer as frame number> <condition>\fP or \fI:return :delete <constant positive integer as frame number> <condition>\fP where the frame number is 1 when omitted and the condition is true when omitted.
If the \fI:return\fP instruction try to move a stacked state on the current state of the processor when the return stack is empty, an ILL interruption will be raised.
If the keyword \fI:delete\fP is added, the instruction will free all memory allocated during the current frame.
The instruction has two distinct behaviours:
.IP "frame number is not zero"
If the condition is true, the instruction removes the frame number minus one from the processor return stack, takes the state on the top of the return stack and moves it to the current state of the processor.
.IP "frame number is zero"
The instruction takes the state on the top and moves it to the current state of the processor until the condition becomes true.
It is useful when the condition depends on the \fI:current\fP address or checks a checkpoint.
.SS ":seek"
This instruction moves the read/write cursor in a stream.
The syntax is \fI:seek <input/output reference> <seek mode> <integer as offset>\fP or \fI:seek <input/output reference>\fP where the seek mode is RELATIVE and the offset is zero in this second form.
The second form is often used to return the current position of the cursor in the stream.
The three seek modes are \fBABSOLUTE\fP where the origin is at the beginning of the stream, \fBRELATIVE\fP where the origin is the current cursor position and \fBEND\fP where the origin is the end of the stream.
If the stream is not seekable, an ILL interruption will be raised.
Otherwise, the cursor position is changed and the new position is returned by the instruction.
.SS ":send"
This instruction sends a memory block to a stream.
The syntax of the instruction is \fI:send <input/output reference> <string as block name> <memory block>\fP.
The instruction will read the memory, and send it through the stream. If the stream is based on a socket or pipe tubes, the instruction will wait for a reply and raises an interruption if an error occurs on receiver side. Please refer to the \fI:receive\fP instruction.
The instruction can raise a PIPE interruption if the stream is not writable, not readable when it is based on a socket or pipe tubes. A SEGV interruption is raised if the block is ill-formed. An ABRT interruption is raised in other cases.
.SS ":shutdown"
This instruction shuts the virtual machine down, dump the memory into the memory file and/or generates a core dump if asked.
The syntax is \fI:shutdown <integer as return code> <condition>\fP where the return code is zero if omitted and the condition is true if omitted.
A zero return code means that the program has successfully terminated.
A non zero value means that the program ends with an error returned to the virtual machine caller.
If the code is negative, the memory is not dumped to the memory file and the absolute value of the code is returned to the virtual machine caller.
.SS ":wait"
This instruction has three usages:
.IP "Timed pause"
The first one aims to wait for a number of seconds.
The syntax is \fI:wait <integer as number of seconds>\fP where the waited time is the absolute value of the number of seconds.
If the number of seconds is zero or positive, an interruption with a defined handler will not stop the instruction, and the call to the handler will be done after the \fI:wait\fP instruction.
If the number of seconds is a negative integer, an interruption with a defined handler will cause an immediate call to the handler.
.IP "Server stream sockets streams"
The second one aims to wait for a client to connect to the socket.
The syntax is \fI:wait <server input/output reference> > <connection input/output reference>\fP where the \fB>\fP character separates the two input/output references.
If the stream does not support the operation, an ILL interruption will be raised.
If the connector input/output reference already exists, an ABRT interruption will be raised.
Otherwise, the created stream supports read, write and close operations and will be used to communicate with the calling client.
.IP "Stream event wait"
The third one aims to wait when a read in the specified mode will return a non empty string, or when a write to the stream will not block.
The read mode is the same as the \fI:read\fP instruction.
The syntax is \fI:wait < <read mode> <non empty list of blocs separated by commas>\fP where each block is formed of \fI<address> * <positive integer as size>\fP, with a default size of 1 if omitted; or \fI:wait > <non empty list of blocs separated by commas>\fP.
The first syntax will wait for read events and the second one for write events.
Each given address should contain an input/output reference to an existing stream.
If an address is incorrect, a SEGV interruption will be raised.
If a stream does not exist, an ABRT interruption will be raised.
If the wait is impossible, a PIPE interruption will be raised.
This instruction will return the input/output reference of one stream where an event occured, or the null input/output reference when it has been interrupted.
In read mode, the instruction returns also when a stream ends.
In such case, the following read on this stream will return a null string.
This last usage can be used like in this example:
.nf
	\fI\fB:new\fP IOR*3/streams, IOR/active_stream, STR/data
	$stream  ->  streams
	$stream2 -> (streams+1)
	$stream3 -> (streams+2)
	\fR...\fI
	\fB:wait\fP < LINE streams*3 -> active_stream
	\fB:goto\fP interrupted \fB:unless\fP active_stream \fB:initialised\fP
	\fB:read\fP @active_stream ~s LINE -> data
	\fB:goto\fP end_of_stream \fB:unless\fP data \fB:initialised\fP
	\fR...\fI
	\fB:delete\fP streams*3, active_stream, data\fP
.fi
.SS ":write"
This instruction writes a string or an integer into a stream supporting the write operation.
The syntax is \fI:write <input/output reference> <format> <string or integer to write>\fP.
The ILL interruption is raised if the stream does not support the operation, and the PIPE interruption is raised if the write operation is not possible.
Otherwise, the value is written according the format into the stream.
.SS ":[a-z][a-z_]*"
This instruction is in fact a complete class of instructions.
It corresponds to the different instructions defined in the plugins.
The syntax of one user defined instruction is \fI:<instruction_name> <list of parameters without commas between them>\fP where the instruction_name is an identifier and the parameters can be either values or addresses.
The parameters are converted to be passed to the C/C++ function defined in the plugin, the function is called, and the result is converted and sent to the \fI->\fP instruction if the user defined instruction was combined to it.
.P
For example, a small HTTP server with a lot of possibles enhancements:
.nf

        \fI\fB:interruption\fP KBINT server_close
        \fB:interruption\fP TERM server_close
        \fB:open\fP $server TCP < "::" "http" \fR#use another port if executed as non root\fI
        \fB:interruption\fP PIPE server_close
        \fB:interruption\fP ABRT ignore
\fB:label\fP server_loop
        \fB:wait\fP $server > $client
        \fB:goto\fP client_query \fB:when\fP \fB:clone\fP
        \fB:close\fP $client
        \fB:goto\fP server_loop
\fB:label\fP client_query
        \fB:close\fP $server
        \fB:new\fP STR*2/q, STR/r, INT/t
        \fB:read\fP $client ~s LINE -> q
	\fB:goto\fP client_close \fB:unless\fP q \fB:initialised\fP
        @q / "^GET [^ ]* HTTP" -> (q+1)
        \fB:goto\fP server_internal_error \fB:when\fP @(q+1) \fB:empty\fP
        @q % "^GET " -> q
        @q / "[^ ]*" -> q
\fB:label\fP client_headers
        \fB:read\fP $client ~s LINE -> (q+1)
	\fB:goto\fP client_close \fB:unless\fP (q+1) \fB:initialised\fP
	@(q+1) / "^[^\\r]*" -> (q+1)
        \fB:goto\fP client_headers \fB:unless\fP @(q+1) \fB:empty\fP
        \fB:interruption\fP PIPE server_not_found
	\fB:goto\fP no_default \fB:unless\fP @q = "/"
	"/index.html" -> q
\fB:label\fP no_default
        "www/" + @q -> q
        \fB:open\fP $file < @q
        \fB:read\fP $file ~s ALL -> r
        \fB:close\fP $file
        \fB:size\fP @r -> t
        \fB:write\fP $client ~s "HTTP/1.0 200 OK\\r\\nContent-Length: "
        \fB:write\fP $client ~d @t
        \fB:write\fP $client ~s "\\r\\nContent-type: text/html; charset=utf-8\\r\\nConnection: close\\r\\n\\r\\n"
        \fB:write\fP $client ~s @r
\fB:label\fP client_close
        \fB:close\fP $client
        \fB:delete\fP q*2,r,t
        \fB:shutdown\fP -1
\fB:label\fP server_internal_error
        \fB:write\fP $client ~s "HTTP/1.0 500 Internal Error\\r\\n\\r\\n<html><head></head><body>Internal error</body></html>\\r\\n"
        \fB:goto\fP client_close
\fB:label\fP server_not_found
        \fB:write\fP $client ~s "HTTP/1.0 404 Not Found\\r\\n\\r\\n<html><head></head><body>Not found</body></html>\\r\\n"
        \fB:goto\fP client_close
\fB:label\fP server_close
        \fB:close\fP $server
        \fB:shutdown\fP
\fB:label\fP ignore
        \fB:return\fP\fR

.fi
.SH MEMORY FILE
.SS Purpose
Before the boot time, the virtual machine load a file that represents its initial memory.
At shutdown time, the file can be rewritten with the new state of the memory, to let the capability to the software executed on it to have some permanent data.
.SS Syntax
The file has a quite simple syntax.
All lines that do not start with \fB#>\fP are considered as commentar, and are not parsed.
The syntax of a complete line is \fI#> &<constant address> / <alias> : <type> <value>\fP where the alias part and the value can be omitted.
If the alias is omitted, the preceding slash shall also be absent.
The addresses shall be ordered from the smallest to the biggest.
.P
For example:
.nf
# Memory:
#> &0 : INT 4
#> &1 / s : STR "foo"
#> &2 : BLN
#> &3 / p : PTR
# Aliases:
# p -> &3
# s -> &1
# Free addresses:
# Free blocks:
# End of memory
.fi
.P
In this example, the addresses \fI&0\fP to \fI&3\fP are defined, the addresses \fI&0\fP and \fI&1\fP are initialised, and the addresses \fI&1\fP and \fI&3\fP are linked to an alias.
.P
The user types values are represented by a string containing the result of the serialisation function defined in a plugin.
.SH HOW TO WRITE A PLUGIN
To illustrate this chapter, you can find an example of plugin project in the ===PKGDATADIR=== directory, in the plugin.tar.gz archive (Please refer to the tar command to deflate it.).
This example contains the build system and a minimal code, both using the files installed with this manual.
You can change those settings in the setlgg_machine.h and setlgg_machine.mk files located at the root directory of the plugin tarball.
.SS Plugins?
A plugin aims to extend the capabilities of the virtual machine by calling code compiled by users having specific needs.
The plugins loaded into the virtual machine are specified when the process is launched, and can not be loaded or unloaded afterwards.
.IP "Types"
User defined types are an extension of the memory, allowing it to contain complex structures within a single address, or contain some values that are not handled by default by the virtual machine.
The syntax of the type itself is \fIUSER(<type name>)\fP where the type name shall be declared in a plugin.
There is no way to write constant values of such types into the program, the only way to create those values is to return it from a custom instruction.
.IP "Instructions"
User defined instructions are an extension of the instruction set of the processor, allowing it to run C/C++ code written by the user or a third party.
The syntax of an instruction is \fI:<instruction name> <list of values or addresses>\fP, where the instruction name shall be declared in a plugin, and the head parameters types shall be compliant with the instruction declaration.
The instruction written in the program can have more parameters than its declaration, and no type check will be performed on those parameters.
.SS The plugin code
The code should contain some specific functions with prototypes described in this page.
.IP "The configuration function"
The prototype of the configuration function is \fBvoid plugin_configuration(void *plugin);\fP.
In the code of this function, a call to the function setlgg_machine_plugin_register with the plugin pointer provided as parameter of plugin_configuration, and a char* containing the configuration of the plugin.
.IP
This configuration declares first the name of the plugin with the \fBPLUGIN <plugin name>\fP directive.
.IP
Then, the optional dependencies are specified in the \fBDEPENDS ON <dependencies> END\fP.
The dependencies can be a plugin with the \fBPLUGIN <plugin name>\fP directive, a type with the \fBTYPE <user type name>\fP directive or an instruction with the \fBINSTRUCTION <user instruction name>\fP directive.
The type and instruction directives can be followed by a \fBIN <plugin name>\fP modifier, to specify an implementation of a type or an instruction.
All the dependencies are checked after configuration of the plugins, meaning that the plugins can be specified in any order on the command line.
.IP
The mandatory section \fBCONTAINS <declarations> END\fP describes what contains the plugin.
The declarations can be types with the directive \fBTYPE <type name>\fP or instructions with the directive \fBINSTRUCTION <instruction name> <list of parameters> <return mode>\fP, where the list of parameters can be either types when a value will be passed as a parameter or the \fBADDRESS\fP keyword when a memory address will be passed as parameter, and the return mode can be \fBRETURN\fP when the instruction returns a value, or \fBNO RETURN\fP when the instruction never returns a value.
.IP
Here is an example of plugin configuration, without the C/C++ string syntax:
.nf
	\fI\fBPLUGIN\fP plugin_name
	\fBDEPENDS ON\fP
		\fBPLUGIN\fP other_plugin
		\fBTYPE\fP dumb \fBIN\fP mega_plugin
		\fBINSTRUCTION\fP dumb_too
		\fBINSTRUCTION\fP yahoo \fBIN\fP banzai_plugin
		\fBTYPE\fP useful_type
	\fBEND\fP
	\fBCONTAINS\fP
		\fBTYPE\fP my_type
		\fBINSTRUCTION\fP my_instruction INT \fBADDRESS\fP \fBNO RETURN\fP
		\fBINSTRUCTION\fP another_instruction STR USR(my_type) BLN \fBRETURN\fP
		\fBTYPE\fP antoher_type
	\fBEND\fP\fR
.fi
.IP "The user type functions"
For each declared type, four functions need to be defined in the plugin.
\fBchar* setlgg_machine_<plugin name>_type_<type name>_serialise(const void *object)\fP and \fBvoid* setlgg_machine_<plugin name>_type_<type name>_unserialise(const char *string)\fP will be mainly used to read and write the value from the memory file.
\fBvoid setlgg_machine_<plugin name>_type_<type name>_delete(void *object)\fP and \fBvoid* setlgg_machine_<plugin name>_type_<type name>_copy(const void *object)\fP are used during internal operations on the value requested by the virtual machine core.
.IP "The instruction functions"
For each declared instruction, one function need to be defined in the plugin.
\fBValue* setlgg_machine_<plugin name>_instruction_<instruction name>(void *machine, unsigned long int argc, Value argv[])\fP where the value returned shall be the null pointer when the instruction is declared with the \fBNO RETURN\fP clause, or a valid pointer to a value instancied with the \fBsetlgg_machine_value_new_*(...)\fP functions (Please see below).
The first parameter is a shadow pointer that need to be passed to all callbacks defined in ===PKGINCLUDEDIR===/setlgg_machine.h header file.
The argc and argv parameters work like the ones passed to main, except that the values can have different types, like defined in the ===PKGINCLUDEDIR===/setlgg_machine.h header file.
.SS The virtual machine interface
One of the aim of defining new instructions is to modify the state of the virtual machine itself.
To do this, some functions are defined in the ===PKGINCLUDEDIR===/setlgg_machine.h header with ad hoc documentation for each function.
.P
In this file, some definitions used to communicate between the instruction C/C++ code and the virtual machine core with their helpers are defined.
.SS Official plugins
Some plugins are provided within the virtual machine.
Please have a look into the ===PKGLIBDIR=== to obtain a list of official plugins.
You can obtain the configuration of each plugin using the command \fBstrings ===PKGLIBDIR===/*.so | grep PLUGIN\fP.
.P
If you want to see your plugin integrated as an official plugin, it shall fullfil some conditions:
.nf
	* The plugin shall be memory error free and have no memory leaks,
	* Have a total respect of the guidelines and API of the virtual machine,
	* Have a purpose that can not break by design any local or distant system.
.fi
.SH RETURN VALUES
The virtual machine returns 129 on a compilation, integration or basic execution error, and 130 when wrong arguments are provided on the command line.
In other cases, the return code is determined by the value passed to the \fI:shutdown\fP instruction.
.SH SEE ALSO
	\fBsetlgg_wrapper\fP(1), \fBsetlgg_machine_plugins\fP(7)
.SH AUTHOR
This software is developed and maintained by Julien Bruguier <===EMAILCONTACT===>
.SH BUGS
In case of bug on the virtual machine itself or on an official plugin, please send an email to the address above.
Other plugins are not covered here, please contact the author of the plugin.
