.TH SETLGG_MACHINE_PLUGINS 7 "29 June 2013"
.SH NAME
\fBsetlgg_machine_plugins\fP \- Documentation of official plugins for the setlgg_machine.
.SH DESCRIPTION
.SS "General description"
The official plugins are shared libraries installed with the virtual machine.
Some of them can be ommited by configuration at installation time.
If you want to see your own plugin integrated as an official plugin, it shall fullfil those conditions:
.nf
	* The plugin shall be memory error free and have no memory leaks,
	* Have a total respect of the guidelines and API of the virtual machine,
	* Have a purpose that can not break by design any local or distant system.
.fi
.SS "Plugin real: ===PKGLIBDIR===/setlggmachinepluginreal.so"
This plugin provides the minimum support of real numbers in the virtual machine.
This plugin is always built, and has no dependancy.
The plugin declares the user type \fIUSR(real)\fP, and basic instructions such as:
.IP ":real_addition USR(real) USR(real) -> USR(real)"
.IP ":real_substraction USR(real) USR(real) -> USR(real)"
.IP ":real_multiplication USR(real) USR(real) -> USR(real)"
.IP ":real_division USR(real) USR(real) -> USR(real)"
.IP ":real_negation USR(real) -> USR(real)"
.IP ":real_zero USR(real) STR"
This instruction check whether the real is around zero, and branches to the label written in the string on success.
.IP ":real_positive USR(real) STR"
This instruction check whether the real is greater than zero, and branches to the label written in the string on success.
.IP ":int_to_real INT -> USR(real)"
.IP ":str_to_real STR -> USR(real)"
.IP ":real_to_int USR(real) -> INT"
.IP ":real_to_str USR(real) -> STR"
.SS "Plugin maths: ===PKGLIBDIR===/setlggmachinepluginmaths.so"
This plugin provides basic mathematical functions on real numbers.
This plugin is always built, and has a dependancy on the real plugin.
The plugin only declares the instructions:
.IP ":real_pi -> USR(real)"
.IP ":real_cosinus USR(real) -> USR(real)"
.IP ":real_sinus USR(real) -> USR(real)"
.IP ":real_tangent USR(real) -> USR(real)"
.IP ":real_arccosinus USR(real) -> USR(real)"
.IP ":real_arcsinus USR(real) -> USR(real)"
.IP ":real_arctangent USR(real) -> USR(real)"
.IP ":real_logarithm USR(real) -> USR(real)"
.IP ":real_exponential USR(real) -> USR(real)"
.IP ":real_square_root USR(real) -> USR(real)"
.SS "Plugin strings: ===PKGLIBDIR===/setlggmachinepluginstrings.so"
This plugin provides some advanced features around the STR type.
This plugin is always built, and has no dependancy.
The plugin provides some new instructions:
.IP ":strings_regex STR STR INT -> PTR"
This instruction matches the first string to the pattern contained in the second string.
The number indicates the number of subgroups that can be extracted.
0 indicates that only the text matching the whole pattern will be captured.
For each matches in the string, the instruction builds a vector starting with an integer indicating how many strings have been captured, and the captured substrings.
The first string is the text matching the whole pattern.
The instruction replies with the address of a vector starting with an integer indicates the number of matches, and for each match, a pointer to the vector containing the captured strings.
.IP ":strings_substitute STR STR INT STR -> STR"
This instruction matches the first string to the pattern contained in the second string.
The number indicates which subgroup will be replaced by the fourth argument.
0 indicates that the text matching the whole pattern will be replaced.
The instruction will replace all occurences of the pattern or subgroup in the string.
.IP ":strings_split STR STR -> PTR"
This instruction splits the first string into a vector of strings composed by substrings between the separator indicated in the second argument.
This second argument is a pattern used to find the separators.
The output vector is made of an integer containing the number of found substrings, followed by the substrings.
The instruction returns the address of the vector.
.IP ":strings_token STR STR ADDRESS -> STR"
This instruction extracts from the string at the address the first match of the pattern made of the first and the second parameters.
The instruction returns the first match of the regular expression in the first pattern.
.SS "Plugin dynlib: ===PKGLIBDIR===/setlggmachineplugindynlib.so"
This plugin provides a basic dynamic linker for the machine, and allows binary libraries written in setlgg_machine assembly code.
This plugin is always built, and has no dependancy.
The plugin provides one new instruction:
.IP ":library IOR"
This instruction reads all data from the given input/output reference, and appends the code extracted from the data to the current program.
The functions included in the library can be called using dynamic linkage or static linkage with a hack on the :label definitions.
Too ease the library development and avoid strange behaviours, it is recommanded to start libraries with a :shutdown instruction.
.SS "Plugin streams: ===PKGLIBDIR===/setlggmachinepluginstreams.so"
This plugin enhances the stream manipulations with some useful instructions that are incoherent with the core language.
This plugin is always built, and has no dependancy.
The plugin provides one new instruction:
.IP ":string_stream IOR"
This instruction opens an anonymous pipe stream to convey data internally to the machine and binds the stream to the IOR given in input.
The instruction returns a PIPE interruption if an error occurs.
The opened stream can block on write so you should not put too much data in it, except if you clone the machine to write data in the stream.
The stream accepts only :read, :write and :close instructions.
.SS "Plugin envvar: ===PKGLIBDIR===/setlggmachinepluginenvvar.so"
This plugin provides a basic access to the environment variables.
.IP ":getenvvar STR -> STR"
This instruction returns the value of the given environment variable, or the null string if the variable does not exist.
.IP ":setenvvar STR STR"
This instruction sets or adds a new variable given in the first parameter with the value in the second parameter.
An ABRT interruption is raised if the variable can not be changed.
.IP ":addenvvar STR STR"
This instruction adds a new variable given in the first parameter with the value in the second parameter.
The instruction has no effect if the variable already existed.
.IP ":delenvvar STR"
This instruction deletes the variable given in the first parameter.
The instruction has no effect if the variable does not exist.
.IP ":listenvvar -> PTR"
This instruction allocates an array in memory and returns its address.
The array first contains the size of the array, then each variable is given in two addresses: the first contains the name, the second the value.
.SH SEE ALSO
	\fBsetlgg_machine\fP(1), \fBsetlgg_wrapper\fP(1)
.SH AUTHOR
This software is developed and maintained by Julien Bruguier <===EMAILCONTACT===>
.SH BUGS
In case of bug on the virtual machine itself or on an official plugin, please send an email to the address above.
Other plugins are not covered here, please contact the author of the plugin.
