.TH SETLGG_WRAPPER 1 "15 May 2013"
.SH NAME
\fBsetlgg_wrapper\fP \- creates a wrapper script for the setlgg virtual machine
.SH SYNOPSIS
setlgg_wrapper [options] [input_file]
.SH OPTIONS
.SS Generic options
.IP "-h (Help)"
Displays a short help on the \fBsetlgg_wrapper\fP command and exits.
.IP "-v (Version)"
Displays the version of the \fBsetlgg_wrapper\fP command and exists.
.IP "-q (Quiet)"
Suppress the output while working.
.SS Installer options
.IP "-i (Install)"
In this mode, the wrapper only produces a part of the shell script installing the program and the wrapper from the current directory.
.IP "-I (Install)"
Same as \fI-i\fP, but takes the source directory in argument.
.IP "-r (Remove)"
In this mode, the wrapper only produces a part of the shell script uninstalling the program and the wrapper from the current directory.
.IP "-R (Remove)"
Same as \fI-r\fP, but takes the source directory in argument.
.SS Local installation options
It is the default mode. No particular option to pass for this mode.
.SS System installation options
This mode is triggered by the \fI-p\fP option.
All others options have a default value built on the prefix argument; all other options are customisations overriding the default value.
In this mode, those options become actives and all take one directory path as argument:
.IP "-p (Prefix)"
This directory corresponds to the system installation directory.
.IP "-b (Binary)"
This directory corresponds to where the script will be generated.
.IP "-S (SetLgg)"
This directory corresponds to where all virtual machine files are stored.
It is equivalent to \fI-P\fP, \fI-M\fP, \fI-C\fP and \fI-L\fP with the same argument.
If some options in this list are specified, they override this setting.
.IP "-P (Program)"
This directory corresponds to where the virtual machine program file is stored.
.IP "-M (Memory)"
This directory corresponds to where the virtual machine memory file is stored.
.IP "-C (Coredump)"
This directory corresponds to where the virtual machine coredump files are generated.
.IP "-L (pLugins)"
This directory corresponds to where the virtual machine plugins file are stored.

.IP "Notes:"
.nf
* The directory creations have to be performed before the execution of the command.
* Two substitutions exist on the directories:
	${prefix}  is equal to the -p argument
	${wrapper} is equal to the string in the \fI:wrapper\fP directive
	~          is equal to the string ${HOME} at the beginning of the argument
.fi
.SH DESCRIPTION
The setlgg_wrapper command reads its input, and generates a shell script that:
.IP
reads the command line options and arguments,
.IP
updates the memory file with options and arguments values,
.IP
boots the virtual machine with the proper options.
.HP
The input file name can be replaced by a - or omitted. In this case, the command reads the input from the standard input.
.HP
The input file has a specific format, with directives in this order:
.SS ":wrapper directive"
The mandatory \fI:wrapper "<file name>"\fP directive sets the script file name.
The resulting file must be writable.
The value of the file name can be found in the memory at the address linked to the alias \fIargument\fP.
.SS ":program directive"
The mandatory \fI:program "<file name>"\fP directive sets the file name of the program to be loaded into the virtual machine.
.SS ":memory directive"
The optional \fI:memory "<file name"\fP directive can be used to set the memory file to be used for each time the program is run from this wrapper.
When this directive is not set, the script will take the first argument as memory file name.
.SS ":coredump directive"
The optional \fI:coredump "<file name>"\fP directive can be used to set a core file prefix to virtual machine.
When not set, the -c option is not passed to the virtual machine.
.SS ":plugin directive"
The optional \fI:plugin "<file name>"\fP directive can be repeated, to specify the list of plugins needed by the virtual machine to run the program.
.SS ":option directive"
The optional \fI:option <alias> <type> -<letter>\fP or \fI:option <alias> <type> -<letter> :help "<help text>"\fP can be repeated to specify a set of options to the wrapper script.
If an help string is provided, it will displayed in the help part of the script.
The behaviour of options depends on the type of the option:
.IP ":flag"
A flag is the simpliest option. It is absent from the command line, or present. The result of this option is set to a boolean in memory at the address linked to the given alias in the directive.
The value is TRUE when the option is present, and FALSE otherwise.
.IP ":counter"
A counter is a simple option without parameter that can be repeated on the command line. The result of this option is set to an integer in memory at the address linked to the given alias in the directive.
The value is the number of repetition of the option.
.IP ":integer"
An integer is an option taking an integer as parameter. The value of the parameter is stored to an integer in memory at the address linked to the given alias in the directive.
If the option is absent, the nul integer is set into the memory.
.IP ":string"
An string is an option taking an string as parameter. The value of the parameter is stored to an string in memory at the address linked to the given alias in the directive.
If the option is absent, the nul string is set into the memory.
.SS ":argument directive"
The optional \fI:argument <alias>\fP or \fI:argument <alias> :help "<help text>"\fP can be repeated, and can be used to specify mandatory arguments on the command line.
If an help string is provided, it will be displayed in the help part of the script.
Each mandatory argument will be set to a string in the memory at the address linked to the alias given in the directive.
More arguments can be set to the script command line, and will be put in an array after the argument alias ended by a nul string.
To access to the nth optional argument, the address \fI(argument+n)\fP will be used in the program.
.SH EXAMPLE
This is a complete example of input file that can be given to the wrapper:
.nf

	:wrapper  "test"
	:program  "test.setlggasm"
	:memory   "test.setlggmem"
	:coredump "core"
	:plugin   "setlggmachinepluginreal.so"
	:plugin   "setlggmachinepluginmaths.so"

	:option debug   :flag    -d :help "Debug mode"
	:option verbose :counter -v :help "Log level"
	:option retry   :integer -i :help "Number of retries"
	:option name    :string  -s :help "User name"

	:argument input   :help "Input file name"
	:argument logfile :help "Log file name"

.fi
The corresponding help on the script is:
.nf

	user@host:~$ ./test -h
	test [options] [arguments]

	Options:
	-d              : (Flag debug) Debug mode
	-v              : (Counter verbose) Log level
	-i <integer>    : (retry) Number of retries
	-s <string>     : (name) User name

	Mandatory arguments:
	input: Input file name
	logfile: Log file name

	Optional arguments:
	More arguments can be passed to the command after the last mandatory argument.

	Useful environment variables:
	DEBUG : can be used to pass one shot options to the virtual machine.


.fi
.SH DEFAULT SCRIPT
If the directives \fI:program\fP, \fI:memory\fP and \fI:coredump\fP are not specified, some default values are taken.
So, the wrapper script:
.nf

	:wrapper "script"
	:plugin  "setlggmachinepluginenvvar.so"

.fi
is equivalent to:
.nf

	:wrapper  "script"
	:program  "script.setlggasm"
	:memory   "script.setlggmem"
	:coredump "core_script"
	:plugin   "setlggmachinepluginenvvar.so"

.fi
All directives after \fI:coredump\fP can be specified as usual.
.SH RETURN VALUES
The wrapper returns 0 on success, and 1 on failure, with a text explaining the error.
.SH INSTALL SHELL SCRIPT
The wrapper can help the developper to write a script that installs and uninstalls the files related to the wrapper.
The wrapper produces portions of shell script in its output, and can be used in an installer script.
.SS Outputs
.IP "Script generation"
This mode produces a shell script defining the directories and file names in shell variables.
.IP "Basic install"
This mode produces a shell script creating directories and copying the basic files in system mode.
.IP "Basic uninstall"
This mode produces a shell script removing the basic files in system mode.
.SS "Install script example"
.nf

	#!/bin/sh
	cd $(dirname $0)

	# Generate the wrapper script, and return the configuration in shell variables
	eval $(cat << EOW | setlgg_wrapper -p /usr/local -M '~/.${wrapper}'
	:wrapper  "script"
	:plugin   "libsetlggmachinepluginscript.so"
	:plugin   "setlggmachineplugindynlib.so"
	EOW
	)

	if [ x$1 = "x-r" ] ;
	then
		# Basic uninstallation
	        eval $(setlgg_wrapper -r) 2>/dev/null
		# Uninstall local plugins
		[ x$PLUGIN_DIR !=x ] && (rm $PLUGIN_DIR/*)
	else
		# Install local plugins
		[ x$PREFIX != x ] && ( mkdir -p $PLUGIN_DIR ; cp plugins/*.so* $PLUGIN_DIR)
		# Basic installation
		eval $(setlgg_wrapper -i) 2>/dev/null
	fi

.fi
To see what is run by the script, the \fBsetlgg_wrapper\fP can be invoked alone with the corresponding options.
.SH SEE ALSO
	\fBsetlgg_machine\fP(1), \fBsetlgg_machine_plugins\fP(7)
.SH AUTHOR
This software is developed and maintained by Julien Bruguier <===EMAILCONTACT===>
.SH BUGS
In case of bug on the wrapper, please send an email to the address above.
