/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/adapteur/analyseur/analyseur.h>
#define YYLTYPE SetLgg::Global::Source::Position
#include <src/adapteur/analyseur/includes.h>
#include <src/adapteur/analyseur/analyseur.syn.h>

#include <sys/stat.h>
#include <unistd.h>
#define FICHIER_STDIN "-"
#include <config.h>

using namespace SetLgg::Adapteur;

int adapteurparse(SetLgg::Adapteur::AdapteurSP& adapteur);
int adapteurlex_destroy();
extern FILE* adapteurin;
extern SetLgg::Global::Source::Position adapteurlloc;

Analyseur::~Analyseur()
{
	::adapteurlex_destroy();
}

SetLgg::Adapteur::AdapteurSP Analyseur::analyse(const std::string& source)
{
	AnalyseurSP analyseur = Analyseur::analyseur();
	analyseur->_adapteur_source=source;
	if(analyseur->_adapteur_source.empty())
		analyseur->_adapteur_source=FICHIER_STDIN;
	adapteurin = Analyseur::ouvrir(analyseur->_adapteur_source, adapteurlloc);
	AdapteurSP adapteur;
	if(::adapteurparse(adapteur))
	{
		return AdapteurSP();
	}
	analyseur.reset();
	return adapteur;
}

bool Analyseur::teste_fichier(std::string fichier)
{
#ifdef SETLGG_DEBUG
	std::cerr << "teste fichier " << fichier << std::endl;
#endif
	if(::access(fichier.c_str(),R_OK))
	{
		FILE *fic = ::fopen(fichier.c_str(),"w");
		::fclose(fic);
		return true;
	}
#ifdef SETLGG_DEBUG
	std::cerr << "access " << fichier << std::endl;
#endif
	struct stat buf;
	if(::stat(fichier.c_str(),&buf))
		return false;
#ifdef SETLGG_DEBUG
	std::cerr << "stat " << fichier << std::endl;
#endif
	if(S_ISDIR(buf.st_mode))
		return false;
#ifdef SETLGG_DEBUG
	std::cerr << "OK " << fichier << std::endl;
#endif
	return true;
}

FILE *Analyseur::ouvrir(std::string fichier, SetLgg::Global::Source::Position& position)
{
	SETLGG_TEST(not fichier.empty());
	if(fichier==FICHIER_STDIN)
	{
		position = SetLgg::Global::Source::Position(FICHIER_STDIN);
		return stdin;
	}

	if(not teste_fichier(fichier)) 
		throw SetLgg::Global::Exception::PasDeFichierSource(fichier);

	FILE *fic = ::fopen(fichier.c_str(),"r");
	position = SetLgg::Global::Source::Position(fichier);
	return fic;
}
