/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __ANALYSEUR_ADAPTEUR_ANALYSEUR__
#define __ANALYSEUR_ADAPTEUR_ANALYSEUR__
#include <cstdio>
#include <string>

#include <src/global/global.h>
namespace SetLgg { namespace Adapteur { DECL_SHARED_PTR(Analyseur); } }
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>
#include <src/adapteur/donnees/adapteur.h>

namespace SetLgg
{
	namespace Adapteur
	{
		class Analyseur
		{
			public:
				static AnalyseurSP& analyseur() { static AnalyseurSP analyseur(new Analyseur()); return analyseur; };
				static AdapteurSP analyse(const std::string& source);
				~Analyseur();
			private:
				Analyseur() {};
				std::string _adapteur_source;
				static FILE *ouvrir(std::string fichier, SetLgg::Global::Source::Position& position);
				static bool teste_fichier(std::string fichier);
		};
	}
}
#endif
