/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _ADAPTEUR_DONNEES_ADAPTEUR_H_
#define _ADAPTEUR_DONNEES_ADAPTEUR_H_

#include <vector>
#include <set>

#include <src/global/global.h>
#include <src/global/exceptions.h>

#include <src/adapteur/donnees/installation.h>

namespace SetLgg { namespace Adapteur { DECL_SHARED_PTR(Adapteur); } }

namespace SetLgg
{
	namespace Adapteur
	{
		class AliasDuplique : public SetLgg::Global::Exception::Compilation
		{
			public:
				AliasDuplique(const SetLgg::Global::Source::PositionSP& position)
				:Compilation(position,"An alias can not be defined twice") {};
		};

		class LettreDuplique : public SetLgg::Global::Exception::Compilation
		{
			public:
				LettreDuplique(const SetLgg::Global::Source::PositionSP& position)
				:Compilation(position,"Option letter can not be defined twice") {};
		};

		class Adapteur : public std::enable_shared_from_this<Adapteur>
		{
			public:
				Adapteur() = default;
				Adapteur(const Adapteur&) = delete;
				virtual ~Adapteur() {};
				virtual void operator() () = 0;
				virtual std::string nom_adapteur() const { return ""; }
				virtual std::string nom_programme() const { return ""; }
				virtual std::string nom_memoire() const { return ""; }
				InstallationSP _installation;
			protected:
				template<typename ListeOptions, typename ListeArguments>
				static void test_coherence(const ListeOptions& listeoptions, const ListeArguments& listearguments)
				{
					std::set<std::string> aliases;
					std::set<std::string> options;
					for(auto it=listeoptions.cbegin() ; it!=listeoptions.cend() ; ++it)
					{
						if(not aliases.insert((*it)->_alias).second)
						{
							throw AliasDuplique((*it)->_position);
						}
						if(not options.insert((*it)->_lettre).second)
						{
							throw LettreDuplique((*it)->_position);
						}
					}
					for(auto it=listearguments.cbegin() ; it!=listearguments.cend() ; ++it)
					{
						if(not aliases.insert(it->_alias).second)
						{
							throw AliasDuplique(it->_position);
						}
					}
				}
		};
	}
}

#endif
