/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _ADAPTEUR_DONNEES_ARGUMENT_GENERATION_H_
#define _ADAPTEUR_DONNEES_ARGUMENT_GENERATION_H_

#include <vector>
#include <map>

#include <src/global/global.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Adapteur { DECL_SHARED_PTR(ArgumentGeneration); } }

namespace SetLgg
{
	namespace Adapteur
	{
		class Adapteur;
		class GenerationScript;
		class ArgumentGeneration
		{
			friend class Adapteur;
			friend class GenerationScript;
			public:
				ArgumentGeneration(const std::string& alias, const std::string& aide, const SetLgg::Global::Source::PositionSP& position)
				:_alias(alias), _aide(aide), _position(position) {};
				template<typename oStream>
				friend oStream& operator*(oStream &os, const ArgumentGeneration& argument)
				{
					os << argument._alias << ": " << argument._aide;
					return os;
				}
				template<typename oStream>
				friend oStream& operator&(oStream &os, const ArgumentGeneration& argument)
				{
					os << ":argument " << argument._alias << " \"${ARGUMENT_" << argument._alias << "}\"";
					return os;
				}
			private:
				std::string _alias;
				std::string _aide;
				SetLgg::Global::Source::PositionSP _position;
		};

		typedef std::vector<ArgumentGeneration> ListeArgumentsGeneration;
	}
}

#endif
