/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _ADAPTEUR_DONNEES_ARGUMENT_MANIPULATION_H_
#define _ADAPTEUR_DONNEES_ARGUMENT_MANIPULATION_H_

#include <vector>
#include <map>

#include <src/global/global.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Adapteur { DECL_SHARED_PTR(ArgumentManipulation); } }

namespace SetLgg
{
	namespace Adapteur
	{
		class ArgumentManipulation
		{
			public:
				explicit ArgumentManipulation(const std::string& valeur)
				:_alias(), _valeur(valeur)  {};
				ArgumentManipulation(const std::string& alias, const std::string& valeur)
				:_alias(new std::string(alias)), _valeur(valeur)  {};
				template<typename oStream>
				friend oStream& operator<<(oStream& os, const ArgumentManipulation& argument)
				{
					if(argument._alias)
					{
						os << ":goto argument_" << *(argument._alias) << " :unless " << *(argument._alias) << " :defined" << std::endl
							<< ":delete " << *(argument._alias) << std::endl
							<< ":label argument_" << *(argument._alias) << std::endl
							<< ":new STR/" << *(argument._alias) << std::endl
							<< "\"" << argument._valeur << "\" -> " << *(argument._alias) << std::endl;
					}
					return os;
				}
				template<typename oStream>
				void argument(oStream& os, size_t& indice) const
				{
					if(not _alias)
					{
						os << "\"" << _valeur << "\" -> (argument + " << indice << ")" << std::endl;
						++indice;
					}
				}
				operator size_t () const
				{
					if(_alias)
						return 0;
					return 1;
				}
			private:
				SHARED_PTR(std::string) _alias;
				std::string _valeur;
		};

		typedef std::vector<ArgumentManipulation> ListeArgumentsManipulation;
	}
}

#endif
