/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _ADAPTEUR_DONNEES_GENERATIONSCRIPT_H_
#define _ADAPTEUR_DONNEES_GENERATIONSCRIPT_H_

#include <vector>
#include <map>

#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Adapteur { DECL_SHARED_PTR(GenerationScript); } }

#include <src/adapteur/donnees/adapteur.h>
#include <src/adapteur/donnees/composants.h>
#include <src/adapteur/donnees/optiongeneration.h>
#include <src/adapteur/donnees/argumentgeneration.h>

namespace SetLgg
{
	namespace Adapteur
	{
		class GenerationScript : public Adapteur
		{
			public:
				GenerationScript(const NomAdapteur& adapteur, const Programme& programme, const MemoireSP& memoire, const CoreDumpSP& coredump, const ListePlugins& plugins, const ListeOptionsGeneration& options, const ListeArgumentsGeneration& arguments)
				:_adapteur(adapteur), _programme(programme), _memoire(memoire), _coredump(coredump), _plugins(plugins), _options(options), _arguments(arguments) {};
				GenerationScript(const NomAdapteur& adapteur, const ListePlugins& plugins, const ListeOptionsGeneration& options, const ListeArgumentsGeneration& arguments);
				GenerationScript(const GenerationScript&) = delete;
				virtual void operator() ();
				virtual std::string nom_adapteur() const { return _adapteur; }
				virtual std::string nom_programme() const { return _programme; }
				virtual std::string nom_memoire() const { if(_memoire) return *_memoire; else return ""; }
				virtual ~GenerationScript() {};
			private:
				NomAdapteur _adapteur;
				Programme _programme;
				MemoireSP _memoire;
				CoreDumpSP _coredump;
				ListePlugins _plugins;
				ListeOptionsGeneration _options;
				ListeArgumentsGeneration _arguments;
		};

		class GenerationImpossible : public SetLgg::Global::Exception::Adapteur
		{
			public:
				GenerationImpossible(const std::string& message)
				:Adapteur(std::string("Impossible to generate script")+message) {};
		};
	}
}

#endif
