/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/adapteur/donnees/installation.h>
using namespace SetLgg::Adapteur;

Installation::Installation(const ValeurOptionSP& prefixe, const ValeurOptionSP& adapteur, const ValeurOptionSP& setlgg, const ValeurOptionSP& programme, const ValeurOptionSP& memoire, const ValeurOptionSP& miseaplat, const ValeurOptionSP& plugin, const std::string& nom_adapteur, const std::string& nom_programme, const std::string& nom_memoire)
:_nom_adapteur(nom_adapteur), _nom_programme(nom_programme), _nom_memoire(nom_memoire)
{
	if(not prefixe) //installation locale
		return;
	_prefixe = substitutions(*prefixe);
	if(adapteur)
	{
		_adapteur = substitutions(*adapteur);
	}
	else
	{
		_adapteur = substitutions(_prefixe+"/bin/");
	}
	if(setlgg)
	{
		_programme = substitutions(*setlgg);
		_memoire   = _programme;
		_miseaplat = _programme;
		_plugin    = _programme;
	}
	else
	{
		_programme = substitutions(_prefixe+"/share/${wrapper}/");
		_memoire   = _programme;
		_miseaplat = substitutions("/tmp/");
		_plugin    = substitutions(_prefixe+"/share/${wrapper}/plugins/");
	}
	if(programme)
	{
		_programme = substitutions(*programme);
	}
	if(memoire)
	{
		_memoire = substitutions(*memoire);
	}
	if(miseaplat)
	{
		_miseaplat = substitutions(*miseaplat);
	}
	if(plugin)
	{
		_plugin = substitutions(*plugin);
	}
	_adapteur  = reformate(_adapteur);
	_programme = reformate(_programme);
	_memoire   = reformate(_memoire);
	_miseaplat = reformate(_miseaplat);
	_plugin    = reformate(_plugin);
}

std::string Installation::substitutions(const std::string& valeur) const
{
	return Installation::substitution(Installation::substitution(valeur,"${prefix}",_prefixe),"${wrapper}",_nom_adapteur);
}

std::string Installation::substitution(const std::string& chaine, const std::string& nom, const std::string& valeur)
{
	std::string resultat = chaine;
	size_t indice=resultat.find(nom);
	while(indice!=std::string::npos)
	{
		resultat.replace(indice,nom.length(),valeur);
		indice=resultat.find(nom,indice);
	}
	return resultat;
}

std::string Installation::reformate(const std::string& repertoire)
{
	std::string resultat = substitution(repertoire+"/","//","/");
	if(not resultat.empty() and (resultat.front()=='~'))
	{
		resultat.replace(0,1,"${HOME}");
	}
	return resultat;
}
