/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _ADAPTEUR_DONNEES_INSTALLATION_H_
#define _ADAPTEUR_DONNEES_INSTALLATION_H_

#include <src/global/global.h>

namespace SetLgg { namespace Adapteur { DECL_SHARED_PTR(Installation); typedef std::shared_ptr<std::string> ValeurOptionSP; } }

namespace SetLgg
{
	namespace Adapteur
	{
		class Installation
		{
			public:
				Installation(const ValeurOptionSP& prefixe, const ValeurOptionSP& adapteur, const ValeurOptionSP& setlgg, const ValeurOptionSP& programme, const ValeurOptionSP& memoire, const ValeurOptionSP& miseaplat, const ValeurOptionSP& plugin, const std::string& nom_adapteur, const std::string& nom_programme, const std::string& nom_memoire);
				template<typename oStream>
				friend oStream& operator<<(oStream& os, const Installation& installation)
				{
					if(installation._prefixe.empty())
					{
						os << "echo \"Local installation.\" ;" << std::endl;
					}
					else
					{
						os << "echo \"System installation of " << installation._nom_adapteur << "\" ;" << std::endl;
					}
					os	<< "PREFIX=\"" << installation._prefixe << "\" ;" << std::endl
					 	<< "WRAPPER_DIR=\"" << installation._adapteur << "\" ;" << std::endl
						<< "WRAPPER_NAME=\"" << installation._nom_adapteur << "\" ;"<< std::endl
						<< "PROGRAM_DIR=\"" << installation._programme << "\" ;" << std::endl
						<< "PROGRAM_NAME=\"" << installation._nom_programme << "\" ;" << std::endl
						<< "MEMORY_DIR=\"" << installation._memoire << "\" ;" << std::endl
						<< "MEMORY_NAME=\"" << installation._nom_memoire << "\" ;" << std::endl
						<< "COREDUMP_DIR=\"" << installation._miseaplat << "\" ;" << std::endl
						<< "PLUGIN_DIR=\"" << installation._plugin << "\" ;" << std::endl
					;
					return os;
				}
				std::string _adapteur;
				std::string _programme;
				std::string _memoire;
				std::string _miseaplat;
				std::string _plugin;
			private:
				std::string _prefixe;
				std::string _nom_adapteur;
				std::string _nom_programme;
				std::string _nom_memoire;
				std::string substitutions(const std::string& chaine) const;
				static std::string substitution(const std::string& chaine, const std::string& nom, const std::string& valeur);
				static std::string reformate(const std::string& repertoire);
		};

	}
}

#endif
