/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <sys/types.h>
#include <unistd.h>
#include <cstdio>
#include <string.h>
#include <sys/wait.h>
#include <src/adapteur/donnees/manipulationmemoire.h>
using namespace SetLgg::Adapteur;

#define LECTURE 0
#define ECRITURE 1

void ManipulationMemoire::operator() ()
{
	std::ostringstream programme;
	for(auto it=_options.cbegin() ; it!=_options.cend() ; ++it)
	{
		programme << (**it);
	}
	for(auto it=_arguments.cbegin() ; it!=_arguments.cend() ; ++it)
	{
		programme << (*it);
	}
	programme << ":goto wrapper :unless wrapper :defined" << std::endl
		<< ":delete wrapper" << std::endl
		<< ":label wrapper" << std::endl
		<< ":goto argument :unless argument :defined" << std::endl
		<< ":new INT/wrapper" << std::endl
		<< "-1 -> wrapper" << std::endl
		<< ":label loop" << std::endl
		<< ":increase wrapper" << std::endl
		<< ":goto loop :when (argument+@wrapper) :initialised" << std::endl
		<< ":increase wrapper" << std::endl
		<< ":delete argument*@wrapper, wrapper" << std::endl
		<< ":label argument" << std::endl;
	
	size_t nombre_arguments=2;
	for(auto it=_arguments.cbegin() ; it!=_arguments.cend() ; ++it)
	{
		nombre_arguments += (*it);
	}

	programme << ":new STR*" << nombre_arguments << "/argument" << std::endl;
	programme << "\"" << static_cast<std::string>(_adapteur) << "\" -> argument" << std::endl;
	size_t indice_argument = 1;
	for(auto it=_arguments.cbegin() ; it!=_arguments.cend() ; ++it)
	{
		it->argument(programme,indice_argument);
	}

	int lecture[2];
	int ecriture[2];

	if(::pipe(lecture)<0)
	{
		std::ostringstream details;
		details << SetLgg::Global::Exception::details << std::endl << "pipe: " << ::strerror(errno);
		throw ManipulationImpossible(details.str());
	}

	if(::pipe(ecriture)<0)
	{
		std::ostringstream details;
		details << SetLgg::Global::Exception::details << std::endl << "pipe: " << ::strerror(errno);
		throw ManipulationImpossible(details.str());
	}

	pid_t pid = ::fork();
	if(pid<0)
	{
		std::ostringstream details;
		details << SetLgg::Global::Exception::details << std::endl << "fork: " << ::strerror(errno);
		throw ManipulationImpossible(details.str());
	}
	if(pid==0)
	{ // fils
		::dup2(ecriture[LECTURE],STDIN_FILENO);
		::dup2(lecture[ECRITURE],STDOUT_FILENO);
		::dup2(lecture[ECRITURE],STDERR_FILENO);

		::close(lecture[ECRITURE]);
		::close(ecriture[ECRITURE]);
		
		nombre_arguments=1/*setlgg_machine*/+2*_plugins.size()/*-p plugin.so*/+2/*- ram*/+1/*NULL*/;
		char **parametres = new char*[nombre_arguments];
		parametres[0] = (char*)("setlgg_machine");
		indice_argument = 1;
		for(auto it=_plugins.begin() ; it!=_plugins.end() ; ++it)
		{
			parametres[indice_argument++]=(char*)("-p");
			parametres[indice_argument++]=static_cast<char*>(*it);
		}
		parametres[indice_argument++]=(char*)("-");
		parametres[indice_argument++]=_memoire.pourAppelVM();
		parametres[indice_argument++]=NULL;
		std::string executable(INSTALL_DIR);
		executable += "/setlgg_machine";
		::execvp(executable.c_str(),parametres);
		std::ostringstream details;
		details << SetLgg::Global::Exception::details << std::endl << "execvp: " << ::strerror(errno);
		throw ManipulationImpossible(details.str());
	}
	else
	{ //pere
		std::string prog=programme.str();
		if(::write(ecriture[ECRITURE],prog.c_str(),prog.size())<static_cast<ssize_t>(prog.size()))
		{
			std::ostringstream details;
			details << SetLgg::Global::Exception::details << std::endl << "setlgg_machine: " << std::endl << "Impossible to communicate with the machine" << std::endl;
			throw ManipulationImpossible(details.str());
		}
		::close(ecriture[ECRITURE]);
		int retour;
		::wait(&retour);
		if(not (WIFEXITED(retour) and WEXITSTATUS(retour)==0))
		{
			std::ostringstream details;
			details << SetLgg::Global::Exception::details << std::endl << "setlgg_machine: " << std::endl;
			char buffer[1025];
			long int taille;
			taille=::read(lecture[LECTURE],buffer,1024);
			if(taille>=0)
			{
				details.write(buffer,taille);
			}
			throw ManipulationImpossible(details.str());
		}
		
	}



}
