/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _ADAPTEUR_DONNEES_MANIPULATIONMEMOIRE_H_
#define _ADAPTEUR_DONNEES_MANIPULATIONMEMOIRE_H_

#include <vector>
#include <map>

#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Adapteur { DECL_SHARED_PTR(ManipulationMemoire); } }

#include <src/adapteur/donnees/adapteur.h>
#include <src/adapteur/donnees/composants.h>
#include <src/adapteur/donnees/optionmanipulation.h>
#include <src/adapteur/donnees/argumentmanipulation.h>

namespace SetLgg
{
	namespace Adapteur
	{
		class ManipulationMemoire : public Adapteur
		{
			public:
				ManipulationMemoire(const Memoire& memoire, const NomAdapteur& adapteur, const ListePlugins& plugins, const ListeOptionsManipulation& options, const ListeArgumentsManipulation& arguments)
				:_memoire(memoire), _adapteur(adapteur), _plugins(plugins), _options(options), _arguments(arguments) {};
				ManipulationMemoire(const ManipulationMemoire&) = delete;
				virtual void operator() ();
				virtual operator std::string() const { return _adapteur; }
				virtual ~ManipulationMemoire() {};
			private:
				Memoire _memoire;
				NomAdapteur _adapteur;
				ListePlugins _plugins;
				ListeOptionsManipulation _options;
				ListeArgumentsManipulation _arguments;
		};

		class ManipulationImpossible : public SetLgg::Global::Exception::Adapteur
		{
			public:
				ManipulationImpossible(const std::string& message)
				:Adapteur(std::string("Impossible to update memory")+message) {};
		};
	}
}

#endif
