/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/compilateur/analyseur/analyseur.h>
#define YYLTYPE SetLgg::Global::Source::Position
#include <src/compilateur/analyseur/analyseur.syn.h>

#include <sys/stat.h>
#include <unistd.h>
#define FICHIER_STDIN "-"
#include <config.h>

using namespace SetLgg::Compilateur::Analyseur;

int parseurparse(/*Traceur::Donnees::Instruction::BlocSP&, Traceur::Donnees::Global::CacheObjetGenerique& cache_objets*/);
int parseurlex_destroy();
extern FILE* parseurin;

Analyseur::~Analyseur()
{
	parseurlex_destroy();
}

void Analyseur::analyse(/*ListeFichiers sources*/)
{
	Analyseur analyseur;
	//parseurin = ;
	if(parseurparse())
	{
	}
}

/*
bool Analyseur::teste_fichier(std::string fichier)
{
#ifdef TRACEUR_DEBUG
	std::cerr << "teste fichier " << fichier << std::endl;
#endif
	if(::access(fichier.c_str(),R_OK))
		return false;
#ifdef TRACEUR_DEBUG
	std::cerr << "access " << fichier << std::endl;
#endif
	struct stat buf;
	if(::stat(fichier.c_str(),&buf))
		return false;
#ifdef TRACEUR_DEBUG
	std::cerr << "stat " << fichier << std::endl;
#endif
	if(S_ISDIR(buf.st_mode))
		return false;
#ifdef TRACEUR_DEBUG
	std::cerr << "OK " << fichier << std::endl;
#endif
	return true;
}

FILE *Analyseur::ouvrir(std::string fichier)
{
	TRACEUR_TEST(not fichier.empty());
	if(fichier==FICHIER_STDIN)
		return stdin;
	if(fichier.substr(0,std::string(PREFIXE_STANDARD).size())==PREFIXE_STANDARD)
	{
		std::string suffixe = fichier.substr(std::string(PREFIXE_STANDARD).size());
		std::string prefixe;
		bool substitution = false;
		if(::getenv(VARIABLE_FICHIER))
		{
			prefixe = std::string(::getenv(VARIABLE_FICHIER));
			if(teste_fichier(prefixe+suffixe)) 
			{
				fichier=prefixe+suffixe;
				substitution = true;
#ifdef TRACEUR_DEBUG
				std::cerr << "var\n";
#endif
			}
		}
		if(not substitution and ::getenv("HOME"))
		{
			prefixe = std::string(::getenv("HOME"))+std::string(UTILISATEUR_FICHIER);
#ifdef TRACEUR_DEBUG
			std::cerr << prefixe+suffixe << std::endl;
#endif
			if(teste_fichier(prefixe+suffixe)) 
			{
				fichier=prefixe+suffixe;
				substitution = true;
#ifdef TRACEUR_DEBUG
				std::cerr << "usr\n";
#endif
			}
		}
		if(not substitution)
		{
			prefixe = std::string(SYSTEME_FICHIER);
			if(teste_fichier(prefixe+suffixe)) 
			{
				fichier=prefixe+suffixe;
				substitution = true;
#ifdef TRACEUR_DEBUG
				std::cerr << "sys\n";
#endif
			}
		}
	}

	if(not teste_fichier(fichier)) 
		throw Traceur::Exception::PasDeFichierSource(fichier);

	FILE *fic = ::fopen(fichier.c_str(),"r");
	return fic;
}

FILE *Analyseur::source_suivant(Traceur::Donnees::Source::Position& position)
{
	++_fichier_courant;
	if(_fichier_courant==_parseur_source.end())
		return 0;
	FILE *fd;
	fd=Analyseur::ouvrir(*_fichier_courant);
	if(not fd)
		throw Traceur::Exception::PasDeFichierSource(*_fichier_courant);
	position.nouveau_fichier(*_fichier_courant);
	return fd;
}
*/
