/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _GLOBAL_ANALYSEUR_H_
#define _GLOBAL_ANALYSEUR_H_

#include <src/global/global.h>

#include <src/global/exceptions.h>
namespace SetLgg { namespace Global { namespace Analyseur { } } }

namespace SetLgg
{
	namespace Global
	{
		namespace Analyseur
		{
#define ANALYSEUR_DEBUT_REGLE \
try \
{

#define ANALYSEUR_FIN_REGLE(variable) \
} \
catch(SetLgg::Global::Exception::Execution& e) \
{ \
	variable._exception.reset(new SetLgg::Global::Exception::Execution(e)); \
	return 1; \
} \
catch(SetLgg::Global::Exception::Compilation& e) \
{ \
	variable._exception.reset(new SetLgg::Global::Exception::Compilation(e)); \
	return 1; \
} \
catch(SetLgg::Global::Exception::Integration& e) \
{ \
	variable._exception.reset(new SetLgg::Global::Exception::Integration(e)); \
	return 1; \
} \
catch(SetLgg::Global::Exception::Generique& e) \
{ \
	variable._exception.reset(new SetLgg::Global::Exception::Generique(e)); \
	return 1; \
} \
catch(...) \
{ \
	variable._exception.reset(new SetLgg::Global::Exception::Inconnue("Unknow exception found.")); \
	return 1; \
}

#define ANALYSEUR_FIN_REGLE_IGNORE(flux) \
} \
catch(SetLgg::Global::Exception::Execution& e) \
{ \
	e.format(flux); \
	return 0; \
} \
catch(SetLgg::Global::Exception::Compilation& e) \
{ \
	e.format(flux); \
	return 0; \
} \
catch(SetLgg::Global::Exception::Integration& e) \
{ \
	e.format(flux); \
	return 0; \
} \
catch(SetLgg::Global::Exception::Generique& e) \
{ \
	e.format(flux); \
	return 0; \
} \
catch(...) \
{ \
	flux << "Unknown exception" << std::endl; \
	return 0; \
}
		}
	}
}
#endif
