/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/global/exceptions.h>
#include <sstream>
#include <vector>
using namespace SetLgg::Global::Exception;

std::ostream& SetLgg::Global::Exception::details(std::ostream& os)
{
	os << std::endl << "Details:";
	return os;
}

void Generique::format(std::ostream& os) const
{
	std::istringstream iss;
	iss.str(this->message());

	std::vector<std::string> lignes;
	size_t taille=0;

	while(iss.good())
	{
		std::string ligne;
		getline(iss,ligne);
		if(ligne.size()>taille)
			taille=ligne.size();
		lignes.push_back(ligne);
	}
	std::string s(taille+4,'-');
	s[0]='+';
	s[taille-1+4]='+';
	os << s << std::endl;
	for(auto it = lignes.begin() ; it!=lignes.end() ; ++it)
		os << "| " << (*it) << std::string(taille-it->size(),' ') << " |" << std::endl;
	os << s << std::endl; 
}

