/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _GLOBAL_H_
#define _GLOBAL_H_
#include <memory>
#include <iostream>
#include <sstream>

#define ERREUR_GENERIQUE 129
#define ERREUR_LIGNEDECOMMANDE 130

#define SHARED_PTR(Type) std::shared_ptr< Type >

#define DECL_SHARED_PTR(Type) \
class Type;\
typedef SHARED_PTR(Type) Type##SP;\
typedef SHARED_PTR(const Type) Type##CSP


#define WEAK_PTR(Type) std::weak_ptr< Type >

#define DECL_WEAK_PTR(Type) \
class Type;\
typedef WEAK_PTR(Type) Type##WP;\
typedef WEAK_PTR(const Type) Type##CWP

#define UNIQUE_PTR(Type) std::unique_ptr< Type >

#define DECL_UNIQUE_PTR(Type) \
class Type;\
typedef UNIQUE_PTR(Type) Type##UP;\
typedef UNIQUE_PTR(const Type) Type##CUP

template<typename T>
std::ostream& operator<<(std::ostream& flux, SHARED_PTR(T) t)
{
	if(static_cast<bool>(t)) { flux << (*t); };
	return flux;
}

namespace SetLgg
{
	namespace Global
	{
		template<typename Type>
		struct SPinferieurSP
		{
			bool operator() (SHARED_PTR(Type) gauche, SHARED_PTR(Type) droite)
			{
				return (*gauche)<(*droite);
			};
		};
		template<typename Type>
		struct SPegalSP
		{
			bool operator() (SHARED_PTR(Type) gauche, SHARED_PTR(Type) droite)
			{
				return (*gauche)==(*droite);
			};
		};

		template<typename Variable, int null, typename Fermeture>
			struct Memoire
			{
				Memoire(const Variable& variable)
					:_variable(variable) {};
				~Memoire()
				{
					if(_variable!=null)
					{
						Fermeture fermeture;
						fermeture(_variable);
						_variable=null;
					}
				}
				void commit(Variable& variable)
				{
					variable=_variable;
					_variable=null;
				}
				Variable _variable;
			};

		struct Niveau
		{
			explicit Niveau(const size_t niveau)
				:_niveau(niveau) {};
			template<typename oStream>
				friend oStream& operator<<(oStream& os, const Niveau& niveau)
				{
					for(size_t indice=0 ; indice<niveau._niveau; ++indice)
					{
						os << ".  ";
					}
					return os;
				}
			private:
			const size_t _niveau;
		};

		struct Chaine
		{
			static std::string echappe(const std::string& chaine);
			static std::string desechappe(const std::string& chaine);
			static char *duplique(const char *chaine, const size_t taille);
		};
	}
}

//#define SETLGG_DEBUG 1
#define SETLGG_VALIDE 1
#ifdef SETLGG_DEBUG
#define SETLGG_DEBUG_ETAPE 1
#define SETLGG_VALIDE 1
#endif
#define SETLGG_TRACE std::cerr << __FILE__ << ":" << __LINE__ << "> "
#ifdef SETLGG_VALIDE
#define SETLGG_TEST(expr) if(not (expr)) { std::cerr << "TEST FAUX A " << __FILE__ << ":" << __LINE__ << "> " << #expr << std::endl; throw; }
#else
#define SETLGG_TEST(expr) if(false) {throw expr;}
#endif
#endif
