/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __GLOBAL_SOURCES_POSITION_H_
#define __GLOBAL_SOURCES_POSITION_H_
#include <string>
#include <sstream>

#include <src/global/global.h>
namespace SetLgg { namespace Global { namespace Source { DECL_SHARED_PTR(Position); } } }

namespace SetLgg
{
	namespace Global
	{
		namespace Source
		{
			class Position
			{
				public:
					Position() = default;
					Position(std::string nom_fichier)
					{
						nouveau_fichier(nom_fichier);
					}
					Position(std::string nom_fichier, size_t ligne)
					{
						nouveau_fichier(nom_fichier);
						_ligne=ligne;
					}
					void ligne_suivante() { _ligne++; };
					void nouveau_fichier(std::string fichier)
					{
						_nom_fichier = SHARED_PTR(std::string )(new std::string(fichier));
						_ligne=1;
					};
					operator PositionSP ()
					{
						PositionSP position(new Position());
						position->_nom_fichier=_nom_fichier;
						position->_ligne=_ligne;
						return position;
					};
					operator std::string ()
					{
						std::ostringstream oss;
						if(_nom_fichier)
						{
							oss << "File " << *(_nom_fichier) << ", line " << _ligne << " > ";
						}
						return oss.str();
					};
					const std::string fichier() const { if(_nom_fichier)  return *_nom_fichier; else return ""; };
					const size_t ligne() const { return _ligne; };
					const std::string debogueur()
					{
						std::stringstream oss;
						oss << fichier() << " " << ligne();
						return oss.str();
					};
				private:
					SHARED_PTR(std::string ) _nom_fichier;
					size_t _ligne;
					
			};
		}
	}
}
#endif
