/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _TRACE_H_
#define _TRACE_H_
#include <fstream>
#include <string>
#include <sys/types.h>
#include <src/global/global.h>

namespace SetLgg { namespace Global { DECL_SHARED_PTR(Trace); } }


namespace SetLgg
{
	namespace Global
	{
		class Trace;

		class TraceInterne
		{
			public:
				virtual ~TraceInterne() {};
				template<typename Objet>
				friend TraceInterne& operator<<(TraceInterne& trace, const Objet& objet)
				{
					if(trace._trace)
					{
						trace._fichier << objet;
					}
					return trace;
				};
				friend void operator<<(TraceInterne& trace, std::ostream& (*endl) (std::ostream&))
				{
					if(trace._trace)
					{
						trace._fichier << std::endl;
					}
				};
			protected:
				TraceInterne() :_trace(false), _processus(0) {};
				TraceInterne(const std::string& fichier);
				bool _trace;
				std::ofstream _fichier;
				pid_t _processus;
		};

		class Trace: private TraceInterne
		{
			public:
				Trace() {};
				Trace(const std::string& nom_fichier)
				:TraceInterne(nom_fichier){};
				virtual ~Trace() { _fichier.close(); };
				operator bool () const { return _trace; };
				template<typename Objet>
				friend TraceInterne& operator<<(TraceSP& trace, const Objet objet)
				{
					if(trace->_trace)
					{
						trace->_fichier << "== " << trace->_processus << " == ";
						trace->_fichier << objet;
					}
					return *trace;
				};

		};
	}
}
#endif
