/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/debogueur/commandes/analyseur.h>
#define YYLTYPE SetLgg::Global::Source::Position
#include <src/machine/debogueur/commandes/includes.h>
#include <src/machine/debogueur/commandes/analyseur.syn.h>

#include <sys/stat.h>
#include <unistd.h>
#define FICHIER_STDIN "-"
#include <config.h>

using namespace SetLgg::Machine::Debogueur;

int debogueurcommandesparse(SetLgg::Machine::Debogueur::DebogueurSP&, const SetLgg::Machine::Programme::ConditionSP& condition, const SetLgg::Machine::Programme::AdresseSP& adresse, const SetLgg::Global::Source::PositionSP&);
extern void* debogueurcommandes_scan_string(const char *);
int debogueurcommandeslex_destroy();
extern FILE* debogueurcommandesin;
extern SetLgg::Global::Source::Position debogueurlloc;

AnalyseurCommandes::~AnalyseurCommandes()
{
	::debogueurcommandeslex_destroy();
}

bool AnalyseurCommandes::analyse_chaine(SetLgg::Machine::Debogueur::DebogueurSP debogueur, std::string source, const SetLgg::Machine::Programme::ConditionSP& condition, const SetLgg::Machine::Programme::AdresseSP& adresse, const SetLgg::Global::Source::PositionSP& position)
{
	AnalyseurCommandes analyseur;
	analyseur._debogueur_source=source;
	::debogueurcommandes_scan_string(analyseur._debogueur_source.c_str());
	return (::debogueurcommandesparse(debogueur,condition,adresse,position)==0);
}
