/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __ANALYSEUR_DEBOGUEUR_ANALYSEUR_COMMANDES__
#define __ANALYSEUR_DEBOGUEUR_ANALYSEUR_COMMANDES__
#include <cstdio>
#include <string>

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>
namespace SetLgg { namespace Machine { namespace Debogueur { DECL_SHARED_PTR(AnalyseurCommandes); } } }
#include <src/machine/debogueur/donnees/debogueur.h>
#include <src/machine/programme/donnees/condition.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Debogueur
		{
			class AnalyseurCommandes
			{
				public:
					static bool analyse_chaine(SetLgg::Machine::Debogueur::DebogueurSP debogueur, std::string source, const SetLgg::Machine::Programme::ConditionSP& condition = SetLgg::Machine::Programme::ConditionSP(), const SetLgg::Machine::Programme::AdresseSP& adresse = SetLgg::Machine::Programme::AdresseSP(), const SetLgg::Global::Source::PositionSP& position = SetLgg::Global::Source::PositionSP());
					~AnalyseurCommandes();
				private:
					AnalyseurCommandes() {};
					std::string _debogueur_source;
			};
		}
	}
}
#endif
