/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/debogueur/donnees/directive.h>
#include <src/machine/debogueur/donnees/variable.h>
#include <src/machine/debogueur/donnees/memoire.h>
#include <src/machine/debogueur/donnees/debogueur.h>
using namespace SetLgg::Machine::Debogueur;

VariableSP DirectiveVariable::evaluation(SetLgg::Machine::Machine::MachineSP& machine, const size_t niveau)
{
	VariableSP variable(new Variable(_nom,niveau,_adresse_memoire,Memoire::resolution(_adresse_memoire,machine),_position));
	return variable;
}

void DirectiveDebutTrame::ajout_debogueur(Debogueur* debogueur, const SetLgg::Machine::Programme::Adresse& adresse) const
{
	SetLgg::Machine::Programme::AdresseSP adresse_reelle(new SetLgg::Machine::Programme::Adresse(*_adresse));
	(*adresse_reelle) += adresse;
	debogueur->directive_debut_trame(adresse_reelle,_position,_condition);
}

void DirectiveFinTrame::ajout_debogueur(Debogueur* debogueur, const SetLgg::Machine::Programme::Adresse& adresse) const
{
	SetLgg::Machine::Programme::AdresseSP adresse_reelle(new SetLgg::Machine::Programme::Adresse(*_adresse));
	(*adresse_reelle) += adresse;
	debogueur->directive_fin_trame(adresse_reelle,_position,_condition);
}

void DirectiveInstruction::ajout_debogueur(Debogueur* debogueur, const SetLgg::Machine::Programme::Adresse& adresse) const
{
	SetLgg::Machine::Programme::AdresseSP adresse_reelle(new SetLgg::Machine::Programme::Adresse(*_adresse));
	(*adresse_reelle) += adresse;
	debogueur->directive_instruction(adresse_reelle,_code,_position,_condition);
}

void DirectiveSymbole::ajout_debogueur(Debogueur* debogueur, const SetLgg::Machine::Programme::Adresse& adresse) const
{
	SetLgg::Machine::Programme::AdresseSP adresse_reelle(new SetLgg::Machine::Programme::Adresse(*_adresse));
	(*adresse_reelle) += adresse;
	debogueur->directive_symbole(adresse_reelle,_symbole,_position,_condition);
}

void DirectiveVariable::ajout_debogueur(Debogueur* debogueur, const SetLgg::Machine::Programme::Adresse& adresse) const
{
	SetLgg::Machine::Programme::AdresseSP adresse_reelle(new SetLgg::Machine::Programme::Adresse(*_adresse));
	(*adresse_reelle) += adresse;
	debogueur->directive_variable(adresse_reelle,_nom,_adresse_memoire,_position,_condition);
}

