/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/debogueur/donnees/memoire.h>
using namespace SetLgg::Machine::Debogueur;

Memoire Memoire::lecture(const SetLgg::Machine::Memoire::Adresse& adresse, SetLgg::Machine::Machine::MachineSP& machine)
{
	Memoire memoire;
	std::ostringstream adresse_str;
	adresse_str << adresse;
	memoire._adresse = adresse_str.str();
	auto type_vrai = machine->_memoire->type(adresse);
	if(type_vrai.first)
	{
		std::ostringstream type;
		type << type_vrai.second;
		memoire._type = type.str();
		try
		{
			SetLgg::Machine::Memoire::ValeurSP valeur_vraie = machine->_memoire->lecture(adresse,SetLgg::Machine::Memoire::Type::tous());
			std::ostringstream valeur;
			valeur << *valeur_vraie;
			memoire._valeur = valeur.str();
			memoire._etat = "Initialised";
		}
		catch(SetLgg::Machine::Memoire::LectureAdresseNonInitialisee& e)
		{
			memoire._etat = "Defined";
		}
	}
	else
	{
		memoire._etat = "Undefined";
	}
	return memoire;
}

bool Memoire::ecriture(const SetLgg::Machine::Memoire::Adresse& adresse, const SetLgg::Machine::Memoire::ValeurCSP& valeur, SetLgg::Machine::Machine::MachineSP& machine)
{
	try
	{
		if(valeur)
		{
			machine->_memoire->ecriture(adresse,valeur);
		}
		else
		{
			machine->_memoire->nettoie(adresse);
		}
		return true;
	} catch(...)
	{
		return false;
	}
}

bool Memoire::suppression(const SetLgg::Machine::Memoire::Adresse& adresse, SetLgg::Machine::Machine::MachineSP& machine)
{
	SetLgg::Machine::Memoire::Memoire::BlocMemoire bloc(adresse,1);
	SetLgg::Machine::Memoire::Memoire::ListeBlocsMemoire liste;
	liste += bloc;
	try
	{
		machine->_memoire->liberation(liste);
		return true;
	}
	catch(...)
	{
		return false;
	}
}

SetLgg::Machine::Memoire::AdresseSP Memoire::resolution(const SetLgg::Machine::Programme::AdresseMemoireSP& adresse, SetLgg::Machine::Machine::MachineSP& machine)
{
	try
	{
		SetLgg::Machine::Memoire::AdresseSP adresse_reelle = adresse->evaluation(machine);
		return adresse_reelle;
	}
	catch(...)
	{
		return SetLgg::Machine::Memoire::AdresseSP();
	}
}

SetLgg::Machine::Memoire::ValeurCSP Memoire::evaluation(const SetLgg::Machine::Programme::ValeurSP& valeur, SetLgg::Machine::Machine::MachineSP& machine)
{
	try
	{
		SetLgg::Machine::Memoire::ValeurCSP valeur_memoire = valeur->evaluation(machine);
		return valeur_memoire;
	}
	catch(...)
	{
		return SetLgg::Machine::Memoire::ValeurCSP();
	}
}
