/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_DEBOGUEUR_DONNEES_MEMOIRE_H_
#define _MACHINE_DEBOGUEUR_DONNEES_MEMOIRE_H_

#include <vector>
#include <map>

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Debogueur { DECL_SHARED_PTR(Memoire); } } }

#include <src/machine/memoire/donnees/adresse.h>
#include <src/machine/memoire/donnees/valeur.h>
#include <src/machine/programme/donnees/valeur.h>
#include <src/machine/machine/machine.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Debogueur
		{
			struct Memoire
			{
				Memoire()
				:_etat("Invalid") {};
				Memoire(const std::string& adresse, const std::string etat, const std::string& type, const std::string valeur)
				:_adresse(adresse), _etat(etat), _type(type), _valeur(valeur) {};
				
				static Memoire lecture(const SetLgg::Machine::Memoire::Adresse& adresse, SetLgg::Machine::Machine::MachineSP& machine);
				static bool ecriture(const SetLgg::Machine::Memoire::Adresse& adresse, const SetLgg::Machine::Memoire::ValeurCSP& valeur, SetLgg::Machine::Machine::MachineSP& machine);
				static bool suppression(const SetLgg::Machine::Memoire::Adresse& adresse, SetLgg::Machine::Machine::MachineSP& machine);
				static SetLgg::Machine::Memoire::AdresseSP resolution(const SetLgg::Machine::Programme::AdresseMemoireSP& adresse, SetLgg::Machine::Machine::MachineSP& machine);
				static SetLgg::Machine::Memoire::ValeurCSP evaluation(const SetLgg::Machine::Programme::ValeurSP& valeur, SetLgg::Machine::Machine::MachineSP& machine);

				std::string _adresse;
				std::string _etat;
				std::string _type;
				std::string _valeur;
			};
		}
	}
}

#endif
