/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/debogueur/donnees/trame.h>
using namespace SetLgg::Machine::Debogueur;

void Trame::traitement(DirectiveSP directive, ListeDirectives& liste_directives, SetLgg::Machine::Machine::MachineSP& machine)
{
	DirectiveVariableSP directive_variable = std::dynamic_pointer_cast<DirectiveVariable>(directive);
	if(std::dynamic_pointer_cast<DirectiveInstruction>(directive))
	{
		liste_directives._instruction=true;
		_instruction_courante = directive;
	}
	else if(std::dynamic_pointer_cast<DirectiveSymbole>(directive))
	{
		_symbole_courant = directive;
	}
	else if(directive_variable)
	{
		VariableSP variable = directive_variable->evaluation(machine,_niveau);
		if(variable)
		{
			_variables[variable->_nom] = variable;
		}
	}
}

void PileTrames::traitement(DirectiveSP directive, ListeDirectives& liste_directives, SetLgg::Machine::Machine::MachineSP& machine)
{
	if(not directive->_condition->evaluation_booleene(machine))
	{
		return;
	}
	DirectiveDebutTrameSP directive_debut_trame = std::dynamic_pointer_cast<DirectiveDebutTrame>(directive);
	if(directive_debut_trame)
	{
		Trame trame(_trames.size(),directive_debut_trame->_position);
		(*this) << trame;
		return;
	}
	DirectiveFinTrameSP directive_fin_trame = std::dynamic_pointer_cast<DirectiveFinTrame>(directive);
	if(directive_fin_trame)
	{
		Trame trame;
		if(not ((*this) >> trame))
		{
			std::cerr << static_cast<std::string>(*directive_fin_trame->_position) << "Invalid end of frame." << std::endl;
		};
		trame.variables_hors_scope();
		liste_directives._fin_trame=true;
		return;
	}
	(**this).traitement(directive,liste_directives,machine);
}
