/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_DEBOGUEUR_DONNEES_TRAME_H_
#define _MACHINE_DEBOGUEUR_DONNEES_TRAME_H_

#include <vector>
#include <map>

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Debogueur { DECL_SHARED_PTR(Trame); } } }

#include <src/machine/debogueur/donnees/variable.h>
#include <src/machine/debogueur/donnees/directive.h>
#include <src/machine/debogueur/donnees/resultat.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Debogueur
		{
			class Debogueur;
			class PileTrames;

			class Trame
			{
				friend class Debogueur;
				friend class PileTrames;
				public:
					Trame()
					:_niveau(0) {};
					Trame(const size_t niveau, const SetLgg::Global::Source::PositionSP& position)
					:_niveau(niveau), _position(position) {};
					virtual ~Trame() {};
					void traitement(DirectiveSP directive, ListeDirectives& liste_directives, SetLgg::Machine::Machine::MachineSP& machine);
					template<typename ResultatFinal>
					void operator>(ResultatFinal& resultat) const
					{
						std::ostringstream oss;
						oss << "Frame " << _niveau << ":" ;
						std::string instruction = "(Unknown instruction)";
						std::string position = "";
						DirectiveInstructionSP directive_instruction = std::dynamic_pointer_cast<DirectiveInstruction>(_instruction_courante);
						if(directive_instruction)
						{
							instruction = directive_instruction->_code;
							if(directive_instruction->_position)
							{
								position = "(" + directive_instruction->_position->debogueur() + ")";
							}
						}
						resultat | oss.str() | instruction | position;
					};
					template<typename ResultatFinal>
					void operator>>(ResultatFinal& resultat) const
					{
						(*this) > resultat;
						Resultat<Colonne<Alignement::DROITE,10>, Colonne<Alignement::GAUCHE,80> > sous_resultat;
						DirectiveSymboleSP directive_symbole = std::dynamic_pointer_cast<DirectiveSymbole>(_symbole_courant);
						std::vector<std::string> positions;
						if(directive_symbole)
						{
							sous_resultat | "Symbol" | directive_symbole->_symbole;
							if(directive_symbole->_position)
							{
								positions.push_back("("+directive_symbole->_position->debogueur()+")");
							}
						}
						for(auto it=_variables.cbegin() ; it!=_variables.cend() ; ++it)
						{
							std::ostringstream ossvar;
							ossvar << (*(it->second));
							sous_resultat | "Variable" | ossvar.str();
							if(it->second->_position)
							{
								positions.push_back("("+it->second->_position->debogueur()+")");
							}
							else
							{
								positions.push_back("");
							}
						}
						positions.push_back("");
						std::stringstream osssousres;
						osssousres << sous_resultat;
						std::string ligne;
						auto itpos = positions.begin();
						std::getline(osssousres,ligne);
						while(std::getline(osssousres,ligne).good())
						{
							resultat | "" | ligne | *itpos;
							++itpos;
						}
					};
					template<typename oStream>
					friend oStream& operator<<(oStream& os, const Trame& trame)
					{
						Resultat<Colonne<Alignement::DROITE,20>, Colonne<Alignement::GAUCHE, 100>, Colonne<Alignement::GAUCHE, 100> > resultat;
						trame >> resultat;
						os << resultat;
						return os;
					};
					operator size_t () const
					{
						return _niveau;
					};
					void variables_hors_scope()
					{
						for(auto it=_variables.cbegin() ; it!=_variables.cend() ; ++it)
						{
							it->second->_hors_scope = true;
						}
					};
				private:
					size_t _niveau;
					SetLgg::Global::Source::PositionSP _position;
					DirectiveSP _instruction_courante;
					DirectiveSP _symbole_courant;
					ListeVariables _variables;
			};

			class PileTrames
			{
				public:
					PileTrames()
					{
						_trames.push_back(Trame());
					};
					void operator<<(const Trame& trame)
					{
						_trames.push_back(trame);
					};
					bool operator>>(Trame& trame)
					{
						trame = Trame(_trames.back());
						if(_trames.size()>1)
						{
							_trames.pop_back();
							return true;
						}
						return false;
					};
					operator size_t () const
					{
						return _trames.size();
					};
					Trame& operator[] (const size_t niveau)
					{
						return _trames[niveau];
					};
					Trame& operator*()
					{
						return _trames.back();
					};
					const Trame& operator*() const
					{
						return _trames.back();
					};
					operator ListeVariables () const
					{
						ListeVariables liste;
						for(auto it = _trames.crbegin() ; it!=_trames.crend() ; ++it)
						{
							liste.insert(it->_variables.cbegin(),it->_variables.cend());
						}
						return liste;
					};
					void traitement(DirectiveSP directive, ListeDirectives& liste_directives, SetLgg::Machine::Machine::MachineSP& machine);
					template<typename oStream>
					friend oStream& operator<<(oStream& os, const PileTrames& pile)
					{
						Resultat<Colonne<Alignement::DROITE,20>, Colonne<Alignement::GAUCHE, 100>, Colonne<Alignement::GAUCHE, 100> > resultat;
						for(auto it=pile._trames.cbegin() ; it!=pile._trames.cend() ; ++it)
						{
							(*it) >> resultat;
						}
						os << resultat;
						return os;
					};
					template<typename oStream>
					friend oStream& operator<(oStream& os, const PileTrames& pile)
					{
						Resultat<Colonne<Alignement::DROITE,20>, Colonne<Alignement::GAUCHE, 100>, Colonne<Alignement::GAUCHE, 100> > resultat;
						for(auto it=pile._trames.cbegin() ; it!=pile._trames.cend() ; ++it)
						{
							(*it) > resultat;
						}
						os << resultat;
						return os;
					};
				private:
					std::vector<Trame> _trames;
			};

		}
	}
}

#endif
