/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_DEBOGUEUR_DONNEES_VARIABLE_H_
#define _MACHINE_DEBOGUEUR_DONNEES_VARIABLE_H_

#include <vector>
#include <map>

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Debogueur { DECL_SHARED_PTR(Variable); } } }

#include <src/machine/memoire/donnees/adresse.h>
#include <src/machine/programme/donnees/adressememoire.h>
#include <src/machine/machine/machine.h>
#include <src/machine/debogueur/donnees/memoire.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Debogueur
		{
			class Debogueur;
			class Trame;
			class SurveillanceVariable;

			typedef std::map<std::string, VariableSP > ListeVariables;
			class Variable
			{
				friend class Debogueur;
				friend class Trame;
				friend class SurveillanceVariable;
				public:
					Variable(const std::string& nom, const size_t niveau, const SetLgg::Machine::Programme::AdresseMemoireSP& adresse, const SetLgg::Machine::Memoire::AdresseSP& adresse_reelle, const SetLgg::Global::Source::PositionSP& position)
					:_nom(nom), _niveau(niveau), _adresse(adresse), _adresse_reelle(adresse_reelle), _position(position), _hors_scope(false) {};
					virtual ~Variable() {};
					template<typename oStream>
					friend oStream& operator<<(oStream& os, const Variable& variable)
					{
						os << variable._nom << ": " << *variable._adresse << " = ";
						if(variable._adresse_reelle)
						{
							os << (*variable._adresse_reelle);
						}
						else
						{
							os << "<Invalid>";
						}
						return os;
					};
					void renseigne(const size_t niveau_courant, SetLgg::Machine::Machine::MachineSP& machine, std::string& adresse, Memoire& memoire, std::string& position)
					{
						std::ostringstream adresse_str;
						adresse_str << (*_adresse);
						adresse = adresse_str.str();
						if(_position)
						{
							position = _position->debogueur();
						}
						if(not _adresse_reelle)
						{
							memoire._etat = "Invalid";
						}
						else
						{
							memoire = Memoire::lecture(*_adresse_reelle,machine);
						}
						if((niveau_courant<_niveau) or _hors_scope)
						{
							memoire._etat = "Out of scope";
						}
					};
					template<typename Resultat>
					void affiche(Resultat& resultat, const size_t niveau_courant, SetLgg::Machine::Machine::MachineSP& machine)
					{
						std::string adresse;
						Memoire memoire;
						std::string position;
						renseigne(niveau_courant,machine,adresse,memoire,position);
						resultat | _nom | adresse | memoire._etat | memoire._adresse | memoire._type | memoire._valeur | position;
					};
					bool ecriture(const SetLgg::Machine::Memoire::ValeurCSP& valeur, SetLgg::Machine::Machine::MachineSP& machine)
					{
						if(_adresse_reelle)
						{
							return Memoire::ecriture(*_adresse_reelle,valeur,machine);
						}
						return false;
					};
					bool supprime(SetLgg::Machine::Machine::MachineSP& machine)
					{
						if(_adresse_reelle)
						{
							return Memoire::suppression(*_adresse_reelle,machine);
						}
						return false;
					};
				private:
					std::string _nom;
					size_t _niveau;
					SetLgg::Machine::Programme::AdresseMemoireSP _adresse;
					SetLgg::Machine::Memoire::AdresseSP _adresse_reelle;
					SetLgg::Global::Source::PositionSP _position;
					bool _hors_scope;
			};

		}
	}
}

#endif
