/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/flux/gestionnaireflux.h>
using namespace SetLgg::Machine::Flux;

GestionnaireFlux::GestionnaireFlux()
{
	SetLgg::Machine::Memoire::NomFlux nomstdin(SetLgg::Machine::Memoire::NomFlux::Type::STDIN);
	FluxSP fluxstdin(new Stdin());
	ajoute(nomstdin,fluxstdin);
	SetLgg::Machine::Memoire::NomFlux nomstdout(SetLgg::Machine::Memoire::NomFlux::Type::STDOUT);
	FluxSP fluxstdout(new Stdout());
	ajoute(nomstdout,fluxstdout);
	SetLgg::Machine::Memoire::NomFlux nomstderr(SetLgg::Machine::Memoire::NomFlux::Type::STDERR);
	FluxSP fluxstderr(new Stderr());
	ajoute(nomstderr,fluxstderr);
}

void GestionnaireFlux::ouverture(const SetLgg::Machine::Memoire::NomFlux& descripteur, const FluxSP& flux)
{
        if((*this)[descripteur])
        {
                throw FluxDejaOuvert(descripteur);
        }
	flux->descripteur_debug(descripteur);
	flux->ouverture();
	_flux.insert(std::pair<SetLgg::Machine::Memoire::NomFlux,FluxSP>(descripteur,flux));
}

void GestionnaireFlux::fermeture(const SetLgg::Machine::Memoire::NomFlux& descripteur)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
                throw FluxInexistant(descripteur);
        }
	(it->second)->fermeture();
	_flux.erase(descripteur);
}

void GestionnaireFlux::fermeture_lecture(const SetLgg::Machine::Memoire::NomFlux& descripteur)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
                throw FluxInexistant(descripteur);
        }
	(it->second)->fermeture_lecture();
}

void GestionnaireFlux::fermeture_ecriture(const SetLgg::Machine::Memoire::NomFlux& descripteur)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
                throw FluxInexistant(descripteur);
        }
	(it->second)->fermeture_ecriture();
}

void GestionnaireFlux::ecriture(const SetLgg::Machine::Memoire::NomFlux& descripteur, const std::string& valeur)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
                throw FluxInexistant(descripteur);
        }
	(it->second)->ecriture(valeur);
}

const DonneesLues GestionnaireFlux::lecture(const SetLgg::Machine::Memoire::NomFlux& descripteur, const TypeLecture& type)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
                throw FluxInexistant(descripteur);
        }
	return (it->second)->lecture(type);
}

long int GestionnaireFlux::cherche(const SetLgg::Machine::Memoire::NomFlux& descripteur, const TypeCherche type, const long int decalage)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
                throw FluxInexistant(descripteur);
        }
	return (it->second)->cherche(type,decalage);
}

void GestionnaireFlux::attente(const SetLgg::Machine::Memoire::NomFlux& descripteur, const SetLgg::Machine::Memoire::NomFlux& connecteur)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
                throw FluxInexistant(descripteur);
        }
	auto itinsert = _flux.find(connecteur);
        if(itinsert!=_flux.end())
        {
                throw FluxDejaOuvert(connecteur);
        }
	FluxSP flux = (it->second)->attente(connecteur);
	if(flux)
	{
		_flux[connecteur]=flux;
	}
}

bool GestionnaireFlux::lisible(const SetLgg::Machine::Memoire::NomFlux& descripteur)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
		return false;
        }
	return (it->second)->lisible();
	
}

bool GestionnaireFlux::inscriptible(const SetLgg::Machine::Memoire::NomFlux& descripteur)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
		return false;
        }
	return (it->second)->inscriptible();
}

bool GestionnaireFlux::cherchable(const SetLgg::Machine::Memoire::NomFlux& descripteur)
{
	auto it = _flux.find(descripteur);
        if(it==_flux.end())
        {
		return false;
        }
	return (it->second)->cherchable();
}

bool GestionnaireFlux::ajoute(const SetLgg::Machine::Memoire::NomFlux& descripteur, const FluxSP& flux)
{
        if((*this)[descripteur])
        {
		return false;
        }
	flux->descripteur_debug(descripteur);
	_flux.insert(std::pair<SetLgg::Machine::Memoire::NomFlux,FluxSP>(descripteur,flux));
	return true;
}

std::set<int> GestionnaireFlux::descripteurs_non_systeme() const
{
	std::set<int> descripteurs;
	for(auto flux:_flux)
	{
		auto d = flux.second->descripteurs_non_systeme();
		descripteurs.insert(d.cbegin(),d.cend());
	}
	return descripteurs;
}
