/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MACHINE_MACHINE_H_
#define _MACHINE_MACHINE_MACHINE_H_

#include <config.h>

#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Machine { DECL_SHARED_PTR(Machine); DECL_WEAK_PTR(Machine); } } }

#include <src/machine/processeur/processeur.h>
#include <src/machine/memoire/donnees/memoire.h>
#include <src/machine/programme/donnees/programme.h>
#include <src/machine/flux/gestionnaireflux.h>
#include <src/machine/plugin/donnees/gestionnaireplugins.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Plugin
		{
			struct Interface;
		}
		namespace Programme
		{
			class AdresseMemoireAlias;
			class AdresseMemoireCourante;
			class Condition;
			class ConditionAdresseDefinie;
			class ConditionAdresseInitialisee;
			class ConditionDescripteurCherchable;
			class ConditionDescripteurInscriptible;
			class ConditionMarqueur;
			class ConditionDescripteurLisible;
			class DereferenceAdresse;
			class InstructionAllocation;
			class InstructionAppel;
			class InstructionAttenteConnection;
			class InstructionAttenteFlux;
			class InstructionCherche;
			class InstructionClone;
			class InstructionEcriture;
			class InstructionEnfant;
			class InstructionExecution;
			template<typename S> class InstructionFermeture;
			namespace Fermeture
			{
				class Complete;
				class Lecture;
				class Ecriture;
			}
			class InstructionInterruption;
			class InstructionLecture;
			class InstructionLiberation;
			class InstructionMiseAPlat;
			class InstructionNettoie;
			class InstructionOuverture;
			class InstructionRetour;
			class InstructionSaut;
			class InstructionDate;
			class InstructionConversion;
			class InstructionArret;
			class InstructionEnvoi;
			class InstructionReception;
			class InstructionUtilisateur;
			class InstructionAttente;
			class InstructionMarqueur;
			template<int i> class InstructionVariation;
			template<typename I> class InstructionAffectation;
		}
		namespace Debogueur
		{
			DECL_SHARED_PTR(Debogueur);
			class Memoire;
			class Trame;
			class PileTrames;
		}
		namespace Machine
		{
			class Machine : public std::enable_shared_from_this<Machine>
			{
				friend class Memoire::Memoire;
				friend class Processeur::Processeur;
				friend class Programme::AdresseMemoireAlias;
				friend class Programme::AdresseMemoireCourante;
				friend class Programme::Condition;
				friend class Programme::ConditionAdresseDefinie;
				friend class Programme::ConditionAdresseInitialisee;
				friend class Programme::ConditionDescripteurCherchable;
				friend class Programme::ConditionDescripteurInscriptible;
				friend class Programme::ConditionDescripteurLisible;
				friend class Programme::ConditionMarqueur;
				friend class Programme::DereferenceAdresse;
				friend class Programme::InstructionAllocation;
				friend class Programme::InstructionAppel;
				friend class Programme::InstructionAttenteConnection;
				friend class Programme::InstructionAttenteFlux;
				friend class Programme::InstructionCherche;
				friend class Programme::InstructionClone;
				friend class Programme::InstructionEcriture;
				friend class Programme::InstructionEnfant;
				friend class Programme::InstructionExecution;
				template <typename S> friend class Programme::InstructionFermeture;
				friend class Programme::Fermeture::Complete;
				friend class Programme::Fermeture::Lecture;
				friend class Programme::Fermeture::Ecriture;
				friend class Programme::InstructionInterruption;
				friend class Programme::InstructionLecture;
				friend class Programme::InstructionLiberation;
				friend class Programme::InstructionMiseAPlat;
				friend class Programme::InstructionNettoie;
				friend class Programme::InstructionOuverture;
				friend class Programme::InstructionRetour;
				friend class Programme::InstructionSaut;
				friend class Programme::InstructionDate;
				friend class Programme::InstructionEnvoi;
				friend class Programme::InstructionReception;
				friend class Programme::InstructionConversion;
				friend class Programme::InstructionArret;
				friend class Programme::InstructionUtilisateur;
				friend class Programme::InstructionAttente;
				friend class Programme::InstructionMarqueur;
				friend class Programme::Programme;
				friend struct Plugin::Interface;
				template<int i> friend class Programme::InstructionVariation;
				template<typename I> friend class Programme::InstructionAffectation;
				friend class Debogueur::Debogueur;
				friend class Debogueur::Memoire;
				friend class Debogueur::Trame;
				friend class Debogueur::PileTrames;
				public:
					enum class TypeExecution { NORMAL, DEBUG };
					Machine(const std::string& fichier_programme, const std::string& fichier_memoire, const std::string& fichier_coredump, const std::vector<std::string>& liste_plugins, const TypeExecution debogage, const std::string& commandes_debogueur);
					virtual ~Machine() { _memoire.reset(); _programme.reset(); };
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Machine&);
					static size_t execution(MachineSP& machine);
					void arret(bool coredump_machine_virtuelle, bool ecriture_memoire, size_t code_retour, const std::string message_erreur=std::string());
				private:
					SetLgg::Machine::Processeur::ProcesseurSP _processeur;
					SetLgg::Machine::Memoire::MemoireSP _memoire;
					SetLgg::Machine::Programme::ProgrammeSP _programme;
					SetLgg::Machine::Flux::GestionnaireFluxSP _flux;
					SetLgg::Machine::Plugin::GestionnairePluginSP _plugins;
					SetLgg::Machine::Debogueur::DebogueurSP _debogueur;
					std::string _fichier_programme;
					std::string _fichier_memoire;
					std::string _fichier_coredump;
					void ecriture_memoire() const;
					struct CodeRetour
					{
						CodeRetour(size_t code):_code(code) {};
						operator size_t () const { return _code; }
						private:
							size_t _code;
					};
			};

			template<typename oStream>
			oStream& operator<<(oStream& os, const Machine& machine)
			{
				os << "# Virtual machine:" << std::endl << "# Version " << PACKAGE_VERSION << std::endl << "#" << std::endl << *(machine._processeur) << "#" << std::endl << *(machine._flux) << "#" << std::endl << *(machine._memoire) << "#" << std::endl << *(machine._programme) << "#" << std::endl << "# End of virtual machine" << std::endl;
				return os;
			}

		}
	}
}

#endif
