/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/memoire/analyseur/analyseur.h>
#define YYLTYPE SetLgg::Global::Source::Position
#include <src/machine/memoire/analyseur/includes.h>
#include <src/machine/memoire/analyseur/analyseur.syn.h>

#include <sys/stat.h>
#include <unistd.h>
#define FICHIER_STDIN "-"
#include <config.h>

using namespace SetLgg::Machine::Memoire;

int memoireparse(SetLgg::Machine::Memoire::Analyseur&, const SetLgg::Machine::Plugin::GestionnairePluginSP&);
extern void* memoire_scan_string(const char *);
int memoirelex_destroy();
extern FILE* memoirein;
extern SetLgg::Global::Source::Position memoirelloc;

Analyseur::~Analyseur()
{
	::memoirelex_destroy();
}

struct fd_close
{
	fd_close(FILE* file)
	:_file(file) { };
	~fd_close() { ::fclose(_file); };
	FILE *_file;
};

SetLgg::Machine::Memoire::MemoireSP Analyseur::analyse_fichier(const std::string& source, const SetLgg::Machine::Plugin::GestionnairePluginSP& gestionnaireplugins)
{
	Analyseur analyseur = Analyseur::analyseur();
	analyseur._memoire_source=source;
	if(analyseur._memoire_source.empty())
		analyseur._memoire_source=FICHIER_STDIN;
	memoirein = Analyseur::ouvrir(analyseur._memoire_source, memoirelloc);
	fd_close fdin(memoirein);
	analyseur._memoire.reset(new Memoire());
	if(::memoireparse(analyseur,gestionnaireplugins))
	{
		if(analyseur._exception)
		{
			analyseur._exception->banzai();
		}
		return MemoireSP();
	}
	return analyseur._memoire;
}

SetLgg::Machine::Memoire::MemoireSP Analyseur::analyse_chaine(const std::string& source, const SetLgg::Machine::Plugin::GestionnairePluginSP& gestionnaireplugins)
{
	Analyseur analyseur = Analyseur::analyseur();
	analyseur._memoire_source=source;
	::memoire_scan_string(analyseur._memoire_source.c_str());
	analyseur._memoire.reset(new Memoire());
	if(::memoireparse(analyseur,gestionnaireplugins))
	{
		if(analyseur._exception)
		{
			analyseur._exception->banzai();
		}
		return MemoireSP();
	}
	return analyseur._memoire;
}

bool Analyseur::teste_fichier(std::string fichier)
{
#ifdef SETLGG_DEBUG
	std::cerr << "teste fichier " << fichier << std::endl;
#endif
	if(::access(fichier.c_str(),R_OK))
	{
		FILE *fic = ::fopen(fichier.c_str(),"w");
		if(fic)
		{
			::fclose(fic);
			return true;
		}
		return false;
	}
#ifdef SETLGG_DEBUG
	std::cerr << "access " << fichier << std::endl;
#endif
	struct stat buf;
	if(::stat(fichier.c_str(),&buf))
		return false;
#ifdef SETLGG_DEBUG
	std::cerr << "stat " << fichier << std::endl;
#endif
	if(S_ISDIR(buf.st_mode))
		return false;
#ifdef SETLGG_DEBUG
	std::cerr << "OK " << fichier << std::endl;
#endif
	return true;
}

FILE *Analyseur::ouvrir(std::string fichier, SetLgg::Global::Source::Position& position)
{
	SETLGG_TEST(not fichier.empty());
	if(fichier==FICHIER_STDIN)
	{
		position = SetLgg::Global::Source::Position(FICHIER_STDIN);
		return stdin;
	}

	if(not teste_fichier(fichier)) 
		throw SetLgg::Global::Exception::PasDeFichierSource(fichier);

	FILE *fic = ::fopen(fichier.c_str(),"r");
	position = SetLgg::Global::Source::Position(fichier);
	return fic;
}
