/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_ADRESSE_H_
#define _MACHINE_MEMOIRE_ADRESSE_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(Adresse); } } }

#include <src/machine/memoire/donnees/entier.h>
#include <src/machine/memoire/donnees/type.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Memoire
		{
			class Adresse : public Valeur
			{
				public:
					Adresse()
					:_adresse(0) {};
					Adresse(const size_t& adresse)
					:_adresse(adresse) {};
					virtual ~Adresse() {};
					virtual operator const Adresse () const
					{
						return *this;
					};
					Adresse& operator++()
					{
						++_adresse;
						return *this;
					};
					Adresse operator+(size_t offset) const
					{
						return Adresse(_adresse+offset);
					};
					Adresse operator+(const Valeur& decalage) const
					{
						const Entier de = dynamic_cast<const Entier&>(decalage);
						long int d = de;
						return Adresse(_adresse+d);
					};
					Adresse operator-(const Valeur& decalage) const
					{
						const Entier de = dynamic_cast<const Entier&>(decalage);
						long int d = de;
						return Adresse(_adresse-d);
					};
					size_t operator-(const Adresse& adresse) const
					{
						return _adresse-adresse._adresse;
					};
					virtual Valeur& operator+=(const long int variation)
					{
						_adresse += variation;
						return *this;
					};
					bool operator<(const Adresse& adresse) const
					{
						return _adresse<adresse._adresse;
					};
					bool operator==(const Adresse& adresse) const
					{
						return _adresse==adresse._adresse;
					};
					bool operator!=(const Adresse& adresse) const
					{
						return _adresse!=adresse._adresse;
					};
					operator const size_t () const
					{
						return _adresse;
					};
					operator const std::string () const
					{
						std::ostringstream oss;
						format(oss);
						return oss.str();
					};
					template<typename oStream>
					friend oStream& operator<<(oStream& os, const Adresse& adresse)
					{
						os << "&" << adresse._adresse;
						return os;
					};
					virtual std::ostream& format(std::ostream& os) const
					{
						os << (*this);
						return os;
					};
					virtual operator const Type&() const
					{
						return SetLgg::Machine::Memoire::Type::pointeur();
					};
					virtual operator SetLgg_Machine_Value() const
					{
						SetLgg_Machine_Value value;
						value._type._type = SetLgg_Machine_ValueTypeCategory::VALUE_POINTER;
						value._type._user_name = {0, 0};
						value._initialisation = SetLgg_Machine_ValueInitialisation::INITIALISED_VALUE;
						value._value._pointer = _adresse;
						return value;
					};
					virtual Adresse& suivi()
					{
						return *this;
					};
				private:
					size_t _adresse;
					virtual ValeurSP copie() const
					{
						ValeurSP valeur(new Adresse(*this));
						return valeur;
					};
			};

			class AdresseNulle : public Adresse
			{
				public:
					AdresseNulle() {};
					virtual bool est_nulle() const { return true; };
			};
		}
	}
}
#endif
