/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_ALEATOIRE_H_
#define _MACHINE_MEMOIRE_ALEATOIRE_H_

#include <cstdlib>
#include <time.h>
#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(Aleatoire); } } }

#include <src/machine/memoire/donnees/entier.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Memoire
		{
			class Aleatoire : public Entier
			{
				public:
					Aleatoire()
					:Entier(0)
					{
						::srand(::time(NULL));
					};
					explicit Aleatoire(long int entier)
					:Entier(entier) {};
					virtual ~Aleatoire() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Aleatoire&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << ":rand";
					};
					virtual const SetLgg::Machine::Memoire::ValeurCSP evaluation(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						EntierCSP entier(new Aleatoire(::rand()));
						return entier;
					};
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Aleatoire& entier)
			{
				return os << entier._entier;
			};
		}
	}
}
#endif
