/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_ALIAS_H_
#define _MACHINE_MEMOIRE_ALIAS_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(Alias); } } }

#include <src/machine/memoire/donnees/adresse.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Memoire
		{
			class Alias
			{
				public:
					Alias(std::string alias)
					:_alias(alias) {};
					virtual ~Alias() {};
					bool operator<(const Alias& alias) const
					{
						return _alias<alias._alias;
					};
					operator std::string () const
					{
						return _alias;
					};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Alias&);
				private:
					std::string _alias;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Alias& alias)
			{
				return os << alias._alias;
			};
		}
	}
}
#endif
