/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_BOOLEEN_H_
#define _MACHINE_MEMOIRE_BOOLEEN_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(Booleen); } } }

#include <src/machine/memoire/donnees/valeur.h>
#include <src/machine/programme/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Memoire
		{
			class Booleen : public SetLgg::Machine::Programme::Valeur
			{
				public:
					explicit Booleen(const bool booleen)
					:_booleen(booleen) {};
					virtual ~Booleen() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Booleen&);
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					virtual operator const Type&() const
					{
						return SetLgg::Machine::Memoire::Type::booleen();
					};
					virtual const SetLgg::Machine::Memoire::ValeurCSP evaluation(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						return this->shared_from_this();
					};
					Booleen operator&&(const Booleen& booleen) const
					{
						return Booleen(_booleen and booleen._booleen);
					};
					Booleen operator||(const Booleen& booleen) const
					{
						return Booleen(_booleen or booleen._booleen);
					};
					Booleen operator^(const Booleen& booleen) const
					{
						return Booleen(_booleen xor booleen._booleen);
					};
					Booleen operator!() const
					{
						return Booleen(not _booleen);
					};
					Booleen operator==(const Booleen& booleen) const
					{
						return Booleen(_booleen == booleen._booleen);
					};
					Booleen operator!=(const Booleen& booleen) const
					{
						return Booleen(_booleen != booleen._booleen);
					};
					operator bool() const
					{
						return _booleen;
					};
					virtual operator SetLgg_Machine_Value() const
					{
						SetLgg_Machine_Value value;
						value._type._type = SetLgg_Machine_ValueTypeCategory::VALUE_BOOLEAN;
						value._type._user_name = {0,0};
						value._initialisation = SetLgg_Machine_ValueInitialisation::INITIALISED_VALUE;
						value._value._boolean = _booleen;
						return value;
					};
				private:
					bool _booleen;
					virtual ValeurSP copie() const
					{
						ValeurSP valeur(new Booleen(*this));
						return valeur;
					};
				protected:
					explicit Booleen() :_booleen(false) {};
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Booleen& booleen)
			{
				if(booleen._booleen)
				{
					return os << "TRUE";
				}
				else
				{
					return os << "FALSE";
				}
			};

			class BooleenNul : public Booleen
			{
				public:
					BooleenNul() {};
					virtual bool est_nulle() const { return true; };
			};
		}
	}
}
#endif
