/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_ELEMENT_H_
#define _MACHINE_MEMOIRE_ELEMENT_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(Element); } } }

#include <src/machine/memoire/donnees/type.h>
#include <src/machine/memoire/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Memoire
		{
			class Memoire;
			class Element
			{
				friend class Memoire;
				public:
					Element(Type type, ValeurSP valeur = ValeurSP())
					:_type(type),_valeur(valeur) {};
					virtual ~Element() {};
					template<typename oStream>
					friend oStream& operator<<(oStream& os, const Element& element)
					{
						os << element._type;
						if(element._valeur)
						{
							os << " " << *(element._valeur);
						}
						return os;
					};
					bool initialise() const
					{
						return static_cast<bool>(_valeur);
					};
					void deinitialise()
					{
						_valeur.reset();
					};
					Element(const Element& element)
					:_type(element._type)
					{
						if(element._valeur)
							_valeur = element._valeur->copie();
					}
				private:
					Type _type;
					ValeurSP _valeur;
					operator const Type& () const
					{
						return _type;
					};
			};
		}
	}
}
#endif
