/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/memoire/donnees/entier.h>
#include <src/machine/memoire/donnees/chaine.h>
#include <src/machine/memoire/donnees/booleen.h>
#include <src/machine/memoire/donnees/adresse.h>
#include <src/machine/memoire/donnees/memoire.h>
#include <src/machine/programme/donnees/format.h>
using namespace SetLgg::Machine::Memoire;

Entier::operator const Adresse () const
{
	return Adresse(static_cast<size_t>(_entier));
}

Booleen Entier::operator==(const Entier& entier) const
{
	return Booleen(_entier == entier._entier);
}

Booleen Entier::operator!=(const Entier& entier) const
{
	return Booleen(_entier != entier._entier);
}

Booleen Entier::operator<(const Entier& entier) const
{
	return Booleen(_entier < entier._entier);
}

Booleen Entier::operator<=(const Entier& entier) const
{
	return Booleen(_entier <= entier._entier);
}

Booleen Entier::operator>(const Entier& entier) const
{
	return Booleen(_entier > entier._entier);
}

Booleen Entier::operator>=(const Entier& entier) const
{
	return Booleen(_entier >= entier._entier);
}

Entier Entier::operator/(const Entier& entier) const
{
	if(entier._entier==0)
	{
		throw DivisionOuResteParZero("Division");
	}
	return Entier(_entier/entier._entier);
}

Entier Entier::operator%(const Entier& entier) const
{
	if(entier._entier==0)
	{
		throw DivisionOuResteParZero("Remainder");
	}
	return Entier(_entier%entier._entier);
}

ChaineCSP Entier::en_chaine(const std::string& format) const
{
	SetLgg::Machine::Programme::Format formatteur(format);
	ChaineCSP retour(new const Chaine(formatteur(this->shared_from_this())));
	return retour;
}

