/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_NOM_FLUX_H_
#define _MACHINE_MEMOIRE_NOM_FLUX_H_

#include <algorithm>
#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(NomFlux); } } }

#include <src/machine/memoire/donnees/valeur.h>
#include <src/machine/programme/donnees/valeur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Memoire
		{
			class NomFlux : public Valeur
			{
				public:
					virtual ~NomFlux() {};
					enum class Type {STDIN=0,STDOUT=1,STDERR=2,AUTRE};
					explicit NomFlux(const std::string& nom, const bool identifiant=false)
						:_type(Type::AUTRE),_nom(SetLgg::Global::Chaine::desechappe(nom)),_identifiant(identifiant) {};
					explicit NomFlux(const Type& type)
						:_type(type) {};
					template<typename oStream>
						friend oStream& operator<<(oStream& os, const NomFlux& nomflux)
						{
							std::string descripteur = nomflux;
							return os << descripteur;
						};
					operator const std::string() const
					{
						switch(_type)
						{
							case Type::STDIN:
								return ":stdin";
							case Type::STDOUT:
								return ":stdout";
							case Type::STDERR:
								return ":stderr";	
							case Type::AUTRE:
								break;
						}
						std::ostringstream oss;
						if(_identifiant)
						{
							oss << "$" << SetLgg::Global::Chaine::echappe(_nom);
						}
						else
						{
							oss << "$(\"" << SetLgg::Global::Chaine::echappe(_nom) << "\")";
						}
						return oss.str();
					};
					bool operator<(const NomFlux& nomflux) const
					{
						if(_type<nomflux._type)
							return true;
						if(nomflux._type<_type)
							return false;
						return _nom<nomflux._nom;
					};
					bool operator==(const NomFlux& nomflux) const
					{
#ifdef SETLGG_DEBUG
SETLGG_TRACE << "NomFlux::operator==" << std::endl;
#endif
						if((_type==Type::AUTRE) and (nomflux._type==Type::AUTRE))
						{
#ifdef SETLGG_DEBUG
SETLGG_TRACE << "AUTRE: true" << std::endl;
#endif
							return (_nom==nomflux._nom);
						}
						else
						{
#ifdef SETLGG_DEBUG
SETLGG_TRACE << "type: " << (_type==nomflux._type) << std::endl;
#endif
							return _type==nomflux._type;
						}
					};
					bool operator!=(const NomFlux& nomflux) const
					{
						return not ((*this)==(nomflux));
					};
					virtual std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					virtual operator const SetLgg::Machine::Memoire::Type&() const
					{
						return SetLgg::Machine::Memoire::Type::nom_flux();
					};
					virtual operator SetLgg_Machine_Value() const
					{
						SetLgg_Machine_Value value;
						value._type._type = SetLgg_Machine_ValueTypeCategory::VALUE_INOUTREF;
						value._type._user_name = {0, 0};
						value._initialisation = SetLgg_Machine_ValueInitialisation::INITIALISED_VALUE;
						value._value._inoutref._name = {0, 0};
						switch(_type)
						{
							case Type::STDIN:
								value._value._inoutref._type = SetLgg_Machine_InOutReferenceType::IOR_STDIN;
								break;
							case Type::STDOUT:
								value._value._inoutref._type = SetLgg_Machine_InOutReferenceType::IOR_STDOUT;
								break;
							case Type::STDERR:
								value._value._inoutref._type = SetLgg_Machine_InOutReferenceType::IOR_STDERR;
								break;
							case Type::AUTRE:
								value._value._inoutref._type = SetLgg_Machine_InOutReferenceType::IOR_CUSTOM;
								value._value._inoutref._name = {SetLgg::Global::Chaine::duplique(_nom.c_str(),_nom.size()+1), _nom.size()};
								break;
						}
						return value;
					};
					virtual ValeurSP copie() const
					{
						ValeurSP valeur(new NomFlux(*this));
						return valeur;
					};
				protected:
					NomFlux() :_type(Type::AUTRE) {};
				private:
					Type _type;
					std::string _nom;
					bool _identifiant;

			};

			class NomFluxNul : public NomFlux
			{
				public:
					NomFluxNul() {};
					virtual bool est_nulle() const { return true; };
			};
		}
	}
}
#endif
