/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_PLACEMEMOIRE_H_
#define _MACHINE_MEMOIRE_PLACEMEMOIRE_H_

#include <vector>
#include <src/global/global.h>
#include <src/global/exceptions.h>
#include <src/global/sources/position.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(PlaceMemoire); } } }

#include <src/machine/memoire/donnees/element.h>
#include <src/machine/memoire/donnees/adresse.h>
#include <src/machine/memoire/donnees/alias.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Memoire
		{
			class Memoire;

			class PlaceMemoire
			{
				friend class Memoire;
				public:
					PlaceMemoire(const Type& type, const size_t& repetition, const AliasSP& alias)
					:_type(type),_repetition(repetition),_alias(alias) {};
					operator size_t () const { return _repetition; };
				private:
					Type _type;
					size_t _repetition;
					AliasSP _alias;
			};

		}
	}
}

#endif
