/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_TYPE_H_
#define _MACHINE_MEMOIRE_TYPE_H_

#include <string.h>
#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(Type); } } }

#include <src/machine/plugin/interface/setlgg_machine.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Memoire
		{
			class Utilisateur;
			class Type
			{
				friend class Utilisateur;
				public:
					enum class TypeValeur {ENTIER,CHAINE,BOOLEEN,POINTEUR,NOM_FLUX,UTILISATEUR,ENTIER_OU_CHAINE,ENTIER_OU_POINTEUR,TOUS};
					Type(const TypeValeur& type, const std::string& identifiant = std::string())
					:_type(type), _identifiant(identifiant) {};
					virtual ~Type() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Type&);
					bool operator==(const Type& type) const
					{
						return _type==type._type;
					};
					bool operator!=(const Type& type) const
					{
						return _type!=type._type;
					};
					operator std::string () const
					{
						std::stringstream oss;
						format(oss);
						return oss.str();
					};
					std::ostream& format(std::ostream& os) const
					{
						return os << (*this);
					};
					static const Type& entier()
					{
						static Type type(TypeValeur::ENTIER);
						return type;
					};
					static const Type& chaine()
					{
						static Type type(TypeValeur::CHAINE);
						return type;
					};
					static const Type& booleen()
					{
						static Type type(TypeValeur::BOOLEEN);
						return type;
					};
					static const Type& pointeur()
					{
						static Type type(TypeValeur::POINTEUR);
						return type;
					};
					static const Type& nom_flux()
					{
						static Type type(TypeValeur::NOM_FLUX);
						return type;
					};
					static const Type& entier_ou_chaine()
					{
						static Type type(TypeValeur::ENTIER_OU_CHAINE);
						return type;
					};
					static const Type& entier_ou_pointeur()
					{
						static Type type(TypeValeur::ENTIER_OU_POINTEUR);
						return type;
					};
					static const Type& tous()
					{
						static Type type(TypeValeur::TOUS);
						return type;
					};
					operator SetLgg_Machine_ValueType () const
					{
						SetLgg_Machine_ValueType type;
						type._user_name={0,0};
						switch(_type)
						{
							case TypeValeur::ENTIER:
								{
									type._type = VALUE_INTEGER;
									return type;
								}
								break;
							case TypeValeur::CHAINE:
								{
									type._type = VALUE_STRING;
									return type;
								}
								break;
							case TypeValeur::BOOLEEN:
								{
									type._type = VALUE_BOOLEAN;
									return type;
								}
								break;
							case TypeValeur::POINTEUR:
								{
									type._type = VALUE_POINTER;
									return type;
								}
								break;
							case TypeValeur::NOM_FLUX:
								{
									type._type = VALUE_INOUTREF;
									return type;
								}
								break;
							case TypeValeur::UTILISATEUR:
								{
									type._type = VALUE_USERTYPE;
									type._user_name._buffer = SetLgg::Global::Chaine::duplique(_identifiant.c_str(),_identifiant.size()+1);
									type._user_name._size = _identifiant.size();
									return type;
								}
								break;
							case TypeValeur::TOUS:
								{
									type._type = VALUE_ALL;
									return type;
								}
								break;
							default:
								break;
						}
						throw;
					};
				private:
					TypeValeur _type;
					std::string _identifiant;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Type& type)
			{
				switch(type._type)
				{
					case Type::TypeValeur::ENTIER:
						os << "INT";
						break;
					case Type::TypeValeur::CHAINE:
						os << "STR";
						break;
					case Type::TypeValeur::BOOLEEN:
						os << "BLN";
						break;
					case Type::TypeValeur::POINTEUR:
						os << "PTR";
						break;
					case Type::TypeValeur::NOM_FLUX:
						os << "IOR";
						break;
					case Type::TypeValeur::UTILISATEUR:
						os << "USR(" << type._identifiant << ")";
						break;
					case Type::TypeValeur::ENTIER_OU_CHAINE:
						os << "INT or STR";
						break;
					case Type::TypeValeur::ENTIER_OU_POINTEUR:
						os << "INT or PTR";
						break;
					case Type::TypeValeur::TOUS:
						os << "ALL";
						break;
				}
				return os;
			};
		}
	}
}
#endif
