/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <cstdlib>
#include <src/machine/memoire/donnees/utilisateur.h>
#include <src/machine/plugin/donnees/typeutilisateur.h>
using namespace SetLgg::Machine::Memoire;
Utilisateur::Utilisateur(const SetLgg::Machine::Plugin::TypeUtilisateurSP& type, const std::string& valeur)
:_type(type), _type_valeur(Type::TypeValeur::UTILISATEUR,type->_nom_type)
{
	std::string v = SetLgg::Global::Chaine::desechappe(valeur);
	_valeur = _type->_deserialisation(v.c_str());
	if(not _valeur)
	{
		throw UtilisateurMauvaiseCallback("unserialisation",_type->_nom_type);
	}
}

Utilisateur::Utilisateur(const SetLgg::Machine::Plugin::TypeUtilisateurSP& type, void *valeur)
:_type(type), _valeur(valeur), _type_valeur(Type::TypeValeur::UTILISATEUR,type->_nom_type)
{
}

Utilisateur::Utilisateur(const Utilisateur& utilisateur)
:_type_valeur(utilisateur._type_valeur)
{
	_type=utilisateur._type;
	_valeur=_type->_copie(utilisateur._valeur);
	if(not _valeur)
	{
		throw UtilisateurMauvaiseCallback("copy",_type->_nom_type);
	}
}

Utilisateur::~Utilisateur()
{
	_type->_destruction(_valeur);
}

std::ostream& Utilisateur::format(std::ostream& os) const
{
	os << "\"";
	char *valeur = _type->_serialisation(_valeur);
	if(not valeur)
	{
		throw UtilisateurMauvaiseCallback("serialisation",_type->_nom_type);
	}
	std::string str(valeur);
	os << SetLgg::Global::Chaine::echappe(str);
	::free(valeur);
	return os << "\"";

}
