/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_UTILISATEUR_H_
#define _MACHINE_MEMOIRE_UTILISATEUR_H_

#include <string.h>
#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(Utilisateur); } } }

#include <src/machine/memoire/donnees/valeur.h>
#include <src/machine/programme/donnees/valeur.h>
#include <src/machine/plugin/donnees/typeutilisateur.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionUtilisateur;
		}
		namespace Plugin
		{
			struct Outils;
		}
		namespace Memoire
		{
			class Utilisateur : public SetLgg::Machine::Programme::Valeur
			{
				friend class Programme::InstructionUtilisateur;
				friend class Plugin::Outils;
				public:
					Utilisateur(const SetLgg::Machine::Plugin::TypeUtilisateurSP& type, const std::string& valeur);
					Utilisateur(const Utilisateur& utilisateur);
					virtual ~Utilisateur();
					template<typename oStream>
					friend oStream& operator<<(oStream& os,const Utilisateur& utilisateur)
					{
						return utilisateur.format(os);
					}
					virtual std::ostream& format(std::ostream& os) const;
					virtual operator const Type&() const
					{
						return _type_valeur;
					};
					virtual const SetLgg::Machine::Memoire::ValeurCSP evaluation(SetLgg::Machine::Machine::MachineSP& machine) const
					{
						return this->shared_from_this();
					};
					virtual operator SetLgg_Machine_Value() const
					{
						SetLgg_Machine_Value value;
						value._type._type = SetLgg_Machine_ValueTypeCategory::VALUE_USERTYPE;
						value._type._user_name = { SetLgg::Global::Chaine::duplique(_type_valeur._identifiant.c_str(), _type_valeur._identifiant.size()+1), _type_valeur._identifiant.size() };
						value._initialisation = SetLgg_Machine_ValueInitialisation::INITIALISED_VALUE;
						value._value._user_type = _type->_copie(_valeur);
						return value;
					};
				protected:
					SetLgg::Machine::Plugin::TypeUtilisateurSP _type;
					void *_valeur;
					Type _type_valeur;
					Utilisateur(const SetLgg::Machine::Plugin::TypeUtilisateurSP& type, void *valeur);
					virtual ValeurSP copie() const
					{
						ValeurSP valeur(new Utilisateur(*this));
						return valeur;
					};
			};

			class UtilisateurNul : public Utilisateur
			{
				public:
					UtilisateurNul(const SetLgg::Machine::Plugin::TypeUtilisateurSP& type)
					:Utilisateur(type,0) {};
					virtual bool est_nulle() const { return true; };
			};

			class UtilisateurMauvaiseCallback : public SetLgg::Global::Exception::Integration
			{
				public:
					UtilisateurMauvaiseCallback(const std::string& callback, const std::string& nom_type)
					:Integration(std::string("Bad ")+callback+" of value of type USR("+nom_type+")") {};
			};
		}
	}
}
#endif
