/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef _MACHINE_MEMOIRE_VALEUR_H_
#define _MACHINE_MEMOIRE_VALEUR_H_

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Memoire { DECL_SHARED_PTR(Valeur); } } }

#include <src/machine/machine/valeur.h>
#include <src/machine/memoire/donnees/type.h>
#include <src/machine/plugin/interface/setlgg_machine.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			struct Copie;
		}
		namespace Memoire
		{
			class Adresse;
			class Element;
			DECL_SHARED_PTR(Chaine);
			class Valeur : public std::enable_shared_from_this<Valeur>
			{
				friend struct SetLgg::Machine::Programme::Copie;
				friend class Element;
				public:
					Valeur() = default;
					virtual ~Valeur() {};
					template<typename oStream>
					friend oStream& operator<<(oStream&,const Valeur&);
					virtual std::ostream& format(std::ostream& os) const =0 ;
					virtual operator const Type&() const =0;
					virtual operator const Adresse () const;
					virtual Valeur& operator+=(const long int) { throw; }
					virtual operator SetLgg_Machine_Value() const = 0;
					virtual Adresse& suivi() { throw; };
					virtual bool est_nulle() const { return false; };
					virtual ChaineCSP en_chaine(const std::string& format) const { throw; };
				private:
					virtual ValeurSP copie() const = 0;
			};
			template<typename oStream>
			oStream& operator<<(oStream& os,const Valeur& valeur)
			{
				valeur.format(os);
				return os;
			};
		}
	}
}
#endif
