/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/plugin/analyseur/analyseur.h>
#define YYLTYPE SetLgg::Global::Source::Position
#include <src/machine/plugin/analyseur/includes.h>
#include <src/machine/plugin/analyseur/analyseur.syn.h>

#include <sys/stat.h>
#include <unistd.h>
#include <config.h>

using namespace SetLgg::Machine::Plugin;

extern int pluginparse(SetLgg::Machine::Plugin::Analyseur&);

extern void* plugin_scan_string(const char *);
extern int pluginlex_destroy();
extern SetLgg::Global::Source::Position pluginlloc;

namespace SetLgg
{
	namespace Machine
	{
		namespace Plugin
		{
			namespace Outil
			{
				struct Memoire
				{
					Memoire(const std::string configuration)
					{
						::plugin_scan_string(configuration.c_str());
					};
					~Memoire()
					{
						::pluginlex_destroy();
					};
				};
			}
		}
	}
}

Analyseur::~Analyseur()
{
}

SetLgg::Machine::Plugin::ConfigurationPluginSP Analyseur::analyse(const std::string configuration)
{
	Outil::Memoire memoire(configuration);
	Analyseur analyseur;
	if(::pluginparse(analyseur))
	{
		if(analyseur._exception)
		{
			analyseur._exception->banzai();
		}
		return ConfigurationPluginSP();
	}
	return analyseur._plugin;
}
