/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __MACHINE_PLUGIN_DONNEES_CONFIGURATIONPLUGIN_H__
#define __MACHINE_PLUGIN_DONNEES_CONFIGURATIONPLUGIN_H__

#include <src/global/global.h>

namespace SetLgg { namespace Machine { namespace Plugin { DECL_SHARED_PTR(ConfigurationPlugin); } } }

#include <src/machine/plugin/donnees/dependances.h>
#include <src/machine/plugin/donnees/contenu.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Plugin
		{
			class Analyseur;
			class Plugin;
			class GestionnairePlugin;
			class ConfigurationPlugin
			{
				friend class Analyseur;
				friend class Plugin;
				friend class GestionnairePlugin;
				public:
					ConfigurationPlugin(const std::string& nom_plugin, const ListeDependances& dependances, const ListeContenus& contenu)
					:_nom_plugin(nom_plugin), _dependances(dependances), _contenu(contenu) {};
					template<typename oStream>
					friend oStream& operator<<(oStream& os, const ConfigurationPlugin& config)
					{
						os << "PLUGIN " << config._nom_plugin << std::endl;
						if(not config._dependances.empty())
						{
							os << "DEPENDS ON" << std::endl;
							for(auto it = config._dependances.cbegin() ; it!=config._dependances.cend() ; ++it)
							{
								os << *(*it) << std::endl;
							}
							os << "END" << std::endl;
						}
						os << "CONTAINS" << std::endl;
						for(auto it = config._contenu.cbegin() ; it!=config._contenu.cend() ; ++it)
						{
							os << *(*it) << std::endl;
						}
						os << "END" << std::endl;
						return os;
					};
				private:
					ConfigurationPlugin() {};
					std::string _nom_plugin;
					ListeDependances _dependances;
					ListeContenus _contenu;
			};
		}
	}
}

#endif
