/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <src/machine/plugin/donnees/gestionnaireplugins.h>

using namespace SetLgg::Machine::Plugin;

GestionnairePlugin::GestionnairePlugin(const ListeLibPlugins& listelibplugins)
{
	for(auto it = listelibplugins.cbegin() ; it!=listelibplugins.cend() ; ++it)
	{
		PluginSP plugin(new Plugin(*it));
		if(not _plugins.insert(std::pair<std::string,PluginSP>(plugin->_configuration->_nom_plugin,plugin)).second)
		{
			throw PluginDuplique(plugin->_configuration->_nom_plugin);
		}
		for(auto ittype=plugin->_types.cbegin() ; ittype!=plugin->_types.cend() ; ++ittype)
		{
			auto ittypedefinition = _types.insert(std::pair<std::string,TypeUtilisateurSP>(ittype->first,ittype->second));
			if(not ittypedefinition.second)
			{
				throw PluginTypeDejaDefini(ittype->first,plugin->_configuration->_nom_plugin,ittypedefinition.first->second->_nom_plugin);
			}
		}
		for(auto itinstruction=plugin->_instructions.cbegin() ; itinstruction!=plugin->_instructions.cend() ; ++itinstruction)
		{
			auto itinstructiondefinition = _instructions.insert(std::pair<std::string,InstructionUtilisateurSP>(itinstruction->first,itinstruction->second));
			if(not itinstructiondefinition.second)
			{
				throw PluginInstructionDejaDefinie(itinstruction->first,plugin->_configuration->_nom_plugin,itinstructiondefinition.first->second->_nom_plugin);
			}
		}
	}
	for(auto it=_plugins.cbegin() ; it!=_plugins.cend() ; ++it)
	{
		it->second->verifiedependances(_plugins,_types,_instructions);
	}
}


const TypeUtilisateurSP& GestionnairePlugin::type(const std::string& nom_type, const SetLgg::Global::Source::PositionSP& position) const
{
	auto it = _types.find(nom_type);
	if(it==_types.end())
	{
		throw TypeInexistant(nom_type,position);
	}
	return it->second;
}

const InstructionUtilisateurSP& GestionnairePlugin::instruction(const std::string& nom_instruction, const SetLgg::Global::Source::PositionSP& position) const
{
	auto it = _instructions.find(nom_instruction);
	if(it==_instructions.end())
	{
		throw InstructionInexistante(nom_instruction,position);
	}
	return it->second;
}

GestionnairePlugin::~GestionnairePlugin()
{
}
