/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __MACHINE_PLUGIN_DONNEES_GESTIONNAIREPLUGIN_H__
#define __MACHINE_PLUGIN_DONNEES_GESTIONNAIREPLUGIN_H__

#include <string>
#include <map>
#include <vector>

#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Machine { namespace Plugin { DECL_SHARED_PTR(GestionnairePlugin); DECL_WEAK_PTR(GestionnairePlugin);} } }

#include <src/machine/plugin/donnees/plugin.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Plugin
		{
			typedef std::vector<std::string> ListeLibPlugins;
			class GestionnairePlugin
			{
				public:
					GestionnairePlugin(const ListeLibPlugins& listelibplugins);
					~GestionnairePlugin();
					void enregistre(const void *lib_handler, const std::string& config_plugin);
					const TypeUtilisateurSP& type(const std::string& nom_type, const SetLgg::Global::Source::PositionSP& position = SetLgg::Global::Source::PositionSP()) const;
					const InstructionUtilisateurSP& instruction(const std::string& nom_instruction, const SetLgg::Global::Source::PositionSP& position = SetLgg::Global::Source::PositionSP()) const;
				private:
					std::map<std::string,PluginSP> _plugins;
					std::map<std::string,TypeUtilisateurSP> _types;
					std::map<std::string,InstructionUtilisateurSP> _instructions;
			};

			class PluginDuplique : public SetLgg::Global::Exception::Integration
			{
				public:
					PluginDuplique(const std::string& nom)
					:Integration(std::string("Plugin ")+nom+" included at least twice") {};
			};

			class PluginTypeDejaDefini : public SetLgg::Global::Exception::Integration
			{
				public:
					PluginTypeDejaDefini(const std::string& nom_type, const std::string& nom_plugin, const std::string& nom_plugin_definition)
					:Integration(std::string("Plugin ")+nom_plugin+" defines type "+nom_type+" already defined in plugin "+nom_plugin_definition) {};
			};

			class PluginInstructionDejaDefinie : public SetLgg::Global::Exception::Integration
			{
				public:
					PluginInstructionDejaDefinie(const std::string& nom_instruction, const std::string& nom_plugin, const std::string& nom_plugin_definition)
					:Integration(std::string("Plugin ")+nom_plugin+" defines instruction "+nom_instruction+" already defined in plugin "+nom_plugin_definition) {};
			};

			class TypeInexistant : public SetLgg::Global::Exception::Compilation
			{
				public:
					TypeInexistant(const std::string& nom_type, const SetLgg::Global::Source::PositionSP& position)
					:Compilation(position,std::string("Type ")+nom_type+" does not exist") {};
			};

			class InstructionInexistante : public SetLgg::Global::Exception::Compilation
			{
				public:
					InstructionInexistante(const std::string& nom_type, const SetLgg::Global::Source::PositionSP& position)
					:Compilation(position,std::string("Instruction ")+nom_type+" does not exist") {};
			};
		}
	}
}

#endif
