/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <dlfcn.h>
#include <src/machine/plugin/donnees/instructionutilisateur.h>
using namespace SetLgg::Machine::Plugin;

InstructionUtilisateur::InstructionUtilisateur(const std::string& nom_instruction, const std::string& nom_plugin, const std::vector<ContenuInstructionParametreSP>& parametres, const bool retour, void *plugin_handler)
:_nom_plugin(nom_plugin), _nom_instruction(nom_instruction), _parametres(parametres), _retour(retour)
{
	std::string fonction = "setlgg_machine_";
	fonction += nom_plugin;
	fonction += "_instruction_";
	fonction += nom_instruction;
	_instruction = reinterpret_cast<Instruction>(::dlsym(plugin_handler,fonction.c_str()));
	if(not _instruction)
	{
		throw PluginFonctionManquanteInstuction(nom_plugin,nom_instruction,std::string("SetLgg_Machine_Value* ")+fonction+"(void *, unsigned long int, SetLgg_Machine_Value[])");
	}
}
