/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __MACHINE_PLUGIN_DONNEES_INSTRUCTIONUTILISATEUR_H__
#define __MACHINE_PLUGIN_DONNEES_INSTRUCTIONUTILISATEUR_H__

#include <vector>
#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Machine { namespace Plugin { DECL_SHARED_PTR(InstructionUtilisateur); } } }

#include <src/machine/plugin/interface/setlgg_machine.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Programme
		{
			class InstructionUtilisateur;
		}
		namespace Plugin
		{
			class GestionnairePlugin;
			class DependanceInstruction;
			DECL_SHARED_PTR(ContenuInstructionParametre);
			class InstructionUtilisateur
			{
				friend class GestionnairePlugin;
				friend class DependanceInstruction;
				friend class Programme::InstructionUtilisateur;
				public:
					typedef SetLgg_Machine_Value* (*Instruction)(void *machine, unsigned long int nombre_arguments, SetLgg_Machine_Value parametres[]);
					InstructionUtilisateur(const std::string& nom_instruction, const std::string& nom_plugin, const std::vector<ContenuInstructionParametreSP>& parametres, const bool retour, void *plugin_handler);
				private:
					std::string _nom_plugin;
					std::string _nom_instruction;
					std::vector<ContenuInstructionParametreSP> _parametres;
					bool _retour;
					Instruction _instruction;
			};

			class PluginFonctionManquanteInstuction : public SetLgg::Global::Exception::Integration
			{
				public:
					PluginFonctionManquanteInstuction(const std::string& nom_plugin, const std::string& nom_instruction, const std::string& prototype)
					:Integration(std::string("Missing function ")+prototype+" for instruction "+nom_instruction+" in plugin "+nom_plugin) {};
			};
		}
	}
}
#endif
