/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#include <dlfcn.h>
#include <src/machine/plugin/donnees/plugin.h>
#include <src/machine/plugin/analyseur/analyseur.h>
using namespace SetLgg::Machine::Plugin;

namespace Outil
{
struct DlClose
{
	void operator() (void *handler) const
	{
		::dlclose(handler);
	};
};
}

Plugin::Plugin(const std::string& fichier)
{
	SetLgg::Global::Memoire<void *,0,Outil::DlClose> memoire(::dlopen(fichier.c_str(),RTLD_LAZY|RTLD_GLOBAL));
	if(not memoire._variable)
	{
		std::ostringstream details;
		details << SetLgg::Global::Exception::details << std::endl << ::dlerror();
		throw FichierPluginInvalide(fichier,details.str());
	}
	void (*configuration)(void *plugin_handler) = reinterpret_cast<void (*)(void*)>(::dlsym(memoire._variable,"plugin_configuration"));
	if(not configuration)
	{
		throw PluginConfigurationManquante(fichier);
	}
	(*configuration)(this);
	_configuration = SetLgg::Machine::Plugin::Analyseur::analyse(_configuration_chaine);
	if(not _configuration)
	{
		throw PluginConfigurationInvalide(fichier);
	}
	for(auto it=_configuration->_contenu.cbegin() ; it!=_configuration->_contenu.cend() ; ++it)
	{
		ContenuTypeSP type = std::dynamic_pointer_cast<ContenuType>(*it);
		if(type)
		{
			TypeUtilisateurSP typeutilisateur(new TypeUtilisateur(type->_nom_type,_configuration->_nom_plugin,memoire._variable));
			if(not _types.insert(std::pair<std::string,TypeUtilisateurSP>(type->_nom_type,typeutilisateur)).second)
			{
				throw PluginTypeDuplique(_configuration->_nom_plugin,type->_nom_type);
			}
		}
		ContenuInstructionSP instruction = std::dynamic_pointer_cast<ContenuInstruction>(*it);
		if(instruction)
		{
			InstructionUtilisateurSP instructionutilisateur(new InstructionUtilisateur(instruction->_nom_instruction,_configuration->_nom_plugin,instruction->_parametres,instruction->_retour,memoire._variable));
			if(not _instructions.insert(std::pair<std::string,InstructionUtilisateurSP>(instruction->_nom_instruction,instructionutilisateur)).second)
			{
				throw PluginInstructionDuplique(_configuration->_nom_plugin,instruction->_nom_instruction);
			}
		}
	}
	memoire.commit(_handler);
}

Plugin::~Plugin()
{
	::dlclose(_handler);
}

void Plugin::verifiedependances(const std::map<std::string,PluginSP>& plugins, const std::map<std::string,TypeUtilisateurSP>& types, const std::map<std::string,InstructionUtilisateurSP>& instructions) const
{
	for(auto it=_configuration->_dependances.cbegin() ; it!=_configuration->_dependances.cend() ; ++it)
	{
		(*it)->verifiedependance(_configuration->_nom_plugin,plugins,types,instructions);
	}
}
