/* 
 *  This program is a non relational database language running on a small
 *  virtual machine.
 *  Copyright (C) 2012 Julien Bruguier.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */ 

#ifndef __MACHINE_PLUGIN_DONNEES_PLUGIN_H__
#define __MACHINE_PLUGIN_DONNEES_PLUGIN_H__

#include <map>

#include <src/global/global.h>
#include <src/global/exceptions.h>

namespace SetLgg { namespace Machine { namespace Plugin { DECL_SHARED_PTR(Plugin); } } }

#include <src/machine/plugin/donnees/configurationplugin.h>

namespace SetLgg
{
	namespace Machine
	{
		namespace Plugin
		{
			DECL_SHARED_PTR(TypeUtilisateur);
			DECL_SHARED_PTR(InstructionUtilisateur);
			class GestionnairePlugin;
			class Plugin
			{
				friend class GestionnairePlugin;
				public:
					Plugin(const std::string& fichier);
					~Plugin();
					void configuration(const std::string& config)
					{
						_configuration_chaine=config;
					};
					void verifiedependances(const std::map<std::string,PluginSP>& plugins, const std::map<std::string,TypeUtilisateurSP>& types, const std::map<std::string,InstructionUtilisateurSP>& instructions) const;
				private:
					void *_handler;
					std::string _configuration_chaine;
					ConfigurationPluginSP _configuration;
					std::map<std::string, TypeUtilisateurSP> _types;
					std::map<std::string, InstructionUtilisateurSP> _instructions;
			};

			class FichierPluginInvalide : public SetLgg::Global::Exception::Integration
			{
				public:
					FichierPluginInvalide(const std::string& fichier, const std::string& details = std::string())
					:Integration(std::string("Invalid plugin file ")+fichier+details) {};
			};

			class PluginConfigurationManquante : public SetLgg::Global::Exception::Integration
			{
				public:
					PluginConfigurationManquante(const std::string& fichier)
					:Integration(std::string("Plugin file ")+fichier+" does not contain any void plugin_configuration(void *) function") {};
			};

			class PluginConfigurationInvalide : public SetLgg::Global::Exception::Integration
			{
				public:
					PluginConfigurationInvalide(const std::string& fichier)
					:Integration(std::string("Plugin ")+fichier+" has an invalid configuration") {};
			};

			class PluginTypeDuplique : public SetLgg::Global::Exception::Integration
			{
				public:
					PluginTypeDuplique(const std::string& plugin, const std::string& type)
					:Integration(std::string("Type ")+type+" declared at least twice in plugin "+plugin) {};
			};

			class PluginInstructionDuplique : public SetLgg::Global::Exception::Integration
			{
				public:
					PluginInstructionDuplique(const std::string& plugin, const std::string& instruction)
					:Integration(std::string("Instruction ")+instruction+" declared at least twice in plugin "+plugin) {};
			};
		}
	}
}

#endif
